/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view;

import java.awt.Point;
import nl.lxtreme.ols.api.util.FrequencyUnit;
import nl.lxtreme.ols.api.util.UnitOfTime;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;

final class ViewUtils {
    ViewUtils() {
    }

    public static String formatDutyCycle(Double aDC) {
        if (aDC != null) {
            return String.format("%.1f %%", aDC);
        }
        return "-";
    }

    public static String formatFrequency(Double aFrequency) {
        if (aFrequency != null) {
            return FrequencyUnit.format((double)aFrequency);
        }
        return "-";
    }

    public static String formatPeriodAsFrequency(Double aPeriod) {
        if (aPeriod != null) {
            return FrequencyUnit.format((double)(1.0 / aPeriod));
        }
        return "-";
    }

    public static String formatReference(boolean aHasTimingInformation, double aRefTime) {
        String toolTip = aHasTimingInformation ? ViewUtils.formatTimestamp(aRefTime) : ViewUtils.formatStateValue((int)aRefTime);
        return toolTip;
    }

    public static String formatTime(Double aTime) {
        if (aTime != null) {
            return UnitOfTime.format((double)aTime);
        }
        return "-";
    }

    public static String getToolTipText(SignalDiagramModel aModel, double aRefTime) {
        return ViewUtils.formatReference(aModel.hasTimingData(), aRefTime);
    }

    public static String getToolTipText(SignalDiagramModel aModel, Point aPoint) {
        boolean hasTimingData;
        return ViewUtils.formatReference(hasTimingData, (hasTimingData = aModel.hasTimingData()) ? aModel.getTimestamp(aPoint.x) : (double)aModel.locationToSampleIndex(aPoint));
    }

    private static String formatStateValue(int aSampleIdx) {
        return Integer.toString(aSampleIdx);
    }

    private static String formatTimestamp(double aTime) {
        return UnitOfTime.toUnit((double)aTime).formatHumanReadable(aTime);
    }
}

