/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.UIManager;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.AbstractViewModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.ElementGroup;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElementManager;

public class ChannelLabelsViewModel
extends AbstractViewModel {
    public ChannelLabelsViewModel(SignalDiagramController aController) {
        super(aController);
    }

    public boolean acceptDrop(SignalElement aMovedElement, SignalElement aInsertPoint) {
        boolean result = false;
        if (aMovedElement != null && aInsertPoint != null) {
            result = true;
        }
        return result;
    }

    public SignalElement findSignalElement(Point aCoordinate) {
        return this.getSignalDiagramModel().findSignalElement(aCoordinate);
    }

    public int findSignalElementVirtualOffset(Point aCoordinate) {
        SignalElement signalElement = this.findSignalElement(aCoordinate);
        if (signalElement != null) {
            int spacing = UIManager.getInt("ols.signal.element.spacer.height") / 2;
            return signalElement.getYposition() + signalElement.getHeight() + spacing;
        }
        return -1;
    }

    public final Collection<Channel> getAllChannels() {
        Collection<SignalElement> allElements = this.getSignalElementManager().getAllElements();
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (SignalElement element : allElements) {
            if (!element.isDigitalSignal()) continue;
            channels.add(element.getChannel());
        }
        return channels;
    }

    public int getArcWidth() {
        return UIManager.getInt("ols.channellabels.arc.width");
    }

    public Color getBackgroundColor() {
        Color color = UIManager.getColor("ols.channellabels.background.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public int getGutterWidth() {
        return UIManager.getInt("ols.channellabels.gutter.width");
    }

    public int getHorizontalPadding() {
        return UIManager.getInt("ols.channellabels.label.padding");
    }

    public Font getIndexFont() {
        Font font = UIManager.getFont("ols.channellabels.index.font");
        if (font == null) {
            Font labelFont = this.getLabelFont();
            font = labelFont.deriveFont(0.75f * labelFont.getSize2D());
        }
        return font;
    }

    public Color getIndexForegroundColor() {
        Color color = UIManager.getColor("ols.channellabels.index.color");
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    public Font getLabelFont() {
        Font font = UIManager.getFont("ols.channellabels.label.font");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public Color getLabelForegroundColor() {
        Color color = UIManager.getColor("ols.channellabels.label.foreground.color");
        if (color == null) {
            color = Color.WHITE;
        }
        return color;
    }

    public Color getLabelGradientColor1() {
        Color color = UIManager.getColor("ols.channellabels.label.gradient.1.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Color getLabelGradientColor2() {
        Color color = UIManager.getColor("ols.channellabels.label.gradient.2.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public int getMinimalWidth() {
        return UIManager.getInt("ols.channellabels.minimal.width");
    }

    public Color getTextShadowColor() {
        Color color = UIManager.getColor("ols.channellabels.shadow.color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public boolean isDrawTextShadow() {
        return UIManager.getBoolean("ols.channellabels.shadow.boolean");
    }

    public boolean isShowChannelIndex() {
        return UIManager.getBoolean("ols.channellabels.show.channel.index.boolean");
    }

    public void moveSignalElement(SignalElement aMovedElement, SignalElement aInsertElement) {
        int newIndex;
        SignalElementManager channelGroupManager = this.getSignalElementManager();
        ElementGroup oldGroup = aMovedElement.getGroup();
        ElementGroup newGroup = aInsertElement.getGroup();
        if (aInsertElement.isDigitalSignal()) {
            int offset = oldGroup != newGroup ? 1 : 0;
            newIndex = aInsertElement.getVirtualIndex() + offset;
        } else {
            newIndex = aInsertElement.isSignalGroup() ? 0 : newGroup.getElementCount();
        }
        channelGroupManager.moveElement(aMovedElement, newGroup, newIndex);
    }
}

