/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.laf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import nl.lxtreme.ols.api.util.UnitOfTime;
import nl.lxtreme.ols.client.signaldisplay.model.TimeLineViewModel;
import nl.lxtreme.ols.client.signaldisplay.util.CursorFlagTextFormatter;
import nl.lxtreme.ols.client.signaldisplay.view.TimeLineView;

public class TimeLineUI
extends ComponentUI {
    private static final int PADDING_TOP = 2;
    private static final int PADDING_LEFT = 2;
    private static final int PADDING_RIGHT = 1;
    private static final int PADDING_WIDTH = 3;
    private static final int PADDING_HEIGHT = 4;
    private static final int TEXT_PADDING_X = 2;
    private static final int VERTICAL_PADDING = 1;

    private static RenderingHints createRenderingHints() {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics aGraphics, JComponent aComponent) {
        TimeLineView view = (TimeLineView)aComponent;
        TimeLineViewModel model = view.getModel();
        if (!model.hasData()) {
            return;
        }
        int baseTickYpos = model.getTimeLineHeight() - 1;
        int tickYpos = baseTickYpos - model.getTickHeight();
        int majorTickYpos = baseTickYpos - model.getMajorTickHeight();
        int minorTickYpos = baseTickYpos - model.getMinorTickHeight();
        Graphics2D canvas = (Graphics2D)aGraphics.create();
        try {
            Rectangle clip = canvas.getClipBounds();
            canvas.setRenderingHints(TimeLineUI.createRenderingHints());
            canvas.setBackground(model.getBackgroundColor());
            canvas.clearRect(clip.x, clip.y, clip.width, clip.height);
            Rectangle visibleRect = view.getVisibleRect();
            double zoomFactor = model.getZoomFactor();
            double triggerOffset = (double)model.getTriggerOffset() * zoomFactor;
            double s = model.getPixelsPerSecond();
            double p = model.getSecondsPerPixel();
            double uot = model.getUnitOfTime();
            double ts = uot * s;
            int majorTickInc = (int)Math.max(1.0, Math.pow(10.0, Math.floor(Math.log10(visibleRect.width / 2))));
            int minorTickInc = majorTickInc / 2;
            double minorTickTime = (double)minorTickInc * uot;
            int tickInc = Math.max(1, majorTickInc / 10);
            double tts = (double)majorTickInc * ts;
            double to = triggerOffset % tts;
            int startX = clip.x;
            int endX = clip.x + clip.width;
            int tick = 0;
            for (double x = (Math.floor((double)startX / tts) - 1.0) * tts + to; x <= (double)endX; x += ts) {
                int xPos = (int)Math.round(x) - 1;
                if (xPos >= startX && xPos <= endX) {
                    double time = x - triggerOffset;
                    if (Math.abs(time) < 1.0E-5) {
                        canvas.setColor(model.getTriggerColor());
                    } else {
                        canvas.setColor(model.getTickColor());
                    }
                    String text = null;
                    int textYpos = -1;
                    if (tick % majorTickInc == 0) {
                        textYpos = majorTickYpos;
                        canvas.drawLine(xPos, majorTickYpos, xPos, baseTickYpos);
                        canvas.setFont(model.getMajorTickLabelFont());
                        double t = (double)Math.round(time * p / uot) * uot;
                        text = this.getMajorTimestamp(model, t, uot);
                    } else if (tick % minorTickInc == 0) {
                        textYpos = minorTickYpos;
                        canvas.drawLine(xPos, minorTickYpos, xPos, baseTickYpos);
                        canvas.setFont(model.getMinorTickLabelFont());
                        if (model.isMinorTimestampVisible()) {
                            text = this.getMinorTimestamp(model, time < 0.0 ? -minorTickTime : minorTickTime, uot);
                        }
                    } else if (tick % tickInc == 0) {
                        canvas.drawLine(xPos, tickYpos, xPos, baseTickYpos);
                    }
                    if (text != null) {
                        FontMetrics fm = canvas.getFontMetrics();
                        canvas.setColor(model.getTextColor());
                        int textWidth = fm.stringWidth(text) + 2;
                        int textXpos = Math.max(visibleRect.x, (int)((double)xPos - (double)textWidth / 2.0)) + 1;
                        textYpos = Math.max(visibleRect.y, textYpos - fm.getDescent());
                        this.drawLabel(canvas, model, text, textXpos, textYpos);
                    }
                }
                ++tick;
            }
            if (model.isCursorMode()) {
                this.paintCursorFlags(model, canvas, aComponent);
            }
        }
        finally {
            canvas.dispose();
            canvas = null;
        }
    }

    private String displayTime(double aTime, double aTimeScale, int aPrecision) {
        UnitOfTime timeScale = UnitOfTime.toUnit((double)aTimeScale);
        UnitOfTime time = UnitOfTime.toUnit((double)aTime);
        int mag = 0;
        UnitOfTime ptr = timeScale;
        while (ptr != null && ptr != time) {
            ptr = ptr.predecessor();
            ++mag;
        }
        if (mag > 1) {
            ptr = time.successor();
            if (ptr == null) {
                ptr = timeScale.predecessor();
            }
            return ptr.formatHumanReadable(aTime);
        }
        return time.formatHumanReadable(aTime);
    }

    private void drawLabel(Graphics2D aCanvas, TimeLineViewModel aModel, String aText, int aXpos, int aYpos) {
        if (aModel.isDrawTextShadow()) {
            aCanvas.setColor(aModel.getTextShadowColor());
            aCanvas.drawString(aText, aXpos + 2, aYpos + 2);
        }
        aCanvas.setColor(aModel.getTextColor());
        aCanvas.drawString(aText, aXpos, aYpos);
    }

    private String getMajorTimestamp(TimeLineViewModel aModel, double aTime, double aTimeScale) {
        if (aModel.hasTimingData()) {
            return this.displayTime(aTime, aTimeScale, 2);
        }
        return Integer.toString((int)aTime);
    }

    private String getMinorTimestamp(TimeLineViewModel aModel, double aTime, double aTimeScale) {
        if (aModel.hasTimingData()) {
            UnitOfTime time = UnitOfTime.toUnit((double)aTime);
            return time.formatHumanReadable(aTime);
        }
        return Integer.toString((int)aTime);
    }

    private void paintCursorFlags(TimeLineViewModel aModel, Graphics2D aCanvas, JComponent aComponent) {
        LinkedList<CursorLabel> labels = new LinkedList<CursorLabel>();
        Rectangle clip = aCanvas.getClipBounds();
        aCanvas.setFont(aModel.getCursorFlagFont());
        FontMetrics fm = aCanvas.getFontMetrics();
        int yOffset = fm.getLeading() + fm.getAscent() + 2;
        for (int i = 0; i < 10; ++i) {
            Rectangle boundaries = new Rectangle();
            String flagText = aModel.getCursorFlagText(i, CursorFlagTextFormatter.LabelStyle.LABEL_TIME);
            boundaries.height = fm.getHeight() + 4;
            boundaries.width = fm.stringWidth(flagText) + 3;
            boundaries.x = aModel.getCursorScreenCoordinate(i);
            boundaries.y = aComponent.getHeight() - boundaries.height - 1;
            if (boundaries.x < 0 || !clip.intersects(boundaries)) continue;
            labels.add(new CursorLabel(i, flagText, boundaries));
        }
        Collections.sort(labels);
        this.placeLabels(clip, aModel, labels, fm);
        AlphaComposite alphaComposite = AlphaComposite.SrcOver.derive(0.7f);
        for (CursorLabel label : labels) {
            Rectangle boundaries = label.boundaries;
            Color cursorColor = aModel.getCursorColor(label.index);
            Color cursorTextColor = aModel.getCursorTextColor(label.index);
            Composite oldComposite = aCanvas.getComposite();
            Stroke oldStroke = aCanvas.getStroke();
            aCanvas.setComposite(alphaComposite);
            Polygon flagPoly = label.getPolygon();
            aCanvas.setColor(cursorTextColor);
            aCanvas.fillPolygon(flagPoly);
            aCanvas.setComposite(oldComposite);
            aCanvas.setStroke(oldStroke);
            aCanvas.setColor(cursorColor);
            aCanvas.drawPolygon(flagPoly);
            int textXpos = boundaries.x + (label.mirrored ? 2 : 1);
            int textYpos = boundaries.y + yOffset;
            aCanvas.drawString(label.text, textXpos, textYpos);
        }
    }

    private void placeLabels(Rectangle aClipBounds, TimeLineViewModel aModel, List<CursorLabel> aLabels, FontMetrics aFM) {
        for (int i = 0; i < aLabels.size(); ++i) {
            aLabels.get(i).resetStyle(aClipBounds, aModel, aFM);
        }
        for (int li = aLabels.size() - 1; li > 0; --li) {
            CursorLabel previousLabel = aLabels.get(li - 1);
            CursorLabel currentLabel = aLabels.get(li);
            while (previousLabel.intersects(currentLabel) && currentLabel.hasMoreStyles()) {
                do {
                    previousLabel.useNextStyle(aModel, aFM);
                } while (previousLabel.hasMoreStyles() && (previousLabel.intersects(currentLabel) || !previousLabel.isCompletelyVisible(aClipBounds)));
                if (!previousLabel.intersects(currentLabel) && currentLabel.isCompletelyVisible(aClipBounds)) continue;
                previousLabel.resetStyle(aClipBounds, aModel, aFM);
                currentLabel.useNextStyle(aModel, aFM);
            }
        }
    }

    private static enum LabelPlacement {
        INDEX_ONLY_RIGHT(CursorFlagTextFormatter.LabelStyle.INDEX_ONLY, false),
        INDEX_ONLY_LEFT(CursorFlagTextFormatter.LabelStyle.INDEX_ONLY, true),
        TIME_ONLY_RIGHT(CursorFlagTextFormatter.LabelStyle.TIME_ONLY, false),
        TIME_ONLY_LEFT(CursorFlagTextFormatter.LabelStyle.TIME_ONLY, true),
        LABEL_ONLY_RIGHT(CursorFlagTextFormatter.LabelStyle.LABEL_ONLY, false),
        LABEL_ONLY_LEFT(CursorFlagTextFormatter.LabelStyle.LABEL_ONLY, true),
        INDEX_LABEL_RIGHT(CursorFlagTextFormatter.LabelStyle.INDEX_LABEL, false),
        INDEX_LABEL_LEFT(CursorFlagTextFormatter.LabelStyle.INDEX_LABEL, true),
        LABEL_TIME_RIGHT(CursorFlagTextFormatter.LabelStyle.LABEL_TIME, false),
        LABEL_TIME_LEFT(CursorFlagTextFormatter.LabelStyle.LABEL_TIME, true);

        final CursorFlagTextFormatter.LabelStyle style;
        final boolean mirrored;

        private LabelPlacement(CursorFlagTextFormatter.LabelStyle aStyle, boolean aMirrored) {
            this.style = aStyle;
            this.mirrored = aMirrored;
        }
    }

    private static class CursorLabel
    implements Comparable<CursorLabel> {
        private static final LabelPlacement[] PLACEMENTS = new LabelPlacement[]{LabelPlacement.LABEL_TIME_RIGHT, LabelPlacement.LABEL_TIME_LEFT, LabelPlacement.LABEL_ONLY_LEFT, LabelPlacement.TIME_ONLY_LEFT, LabelPlacement.INDEX_ONLY_LEFT, LabelPlacement.INDEX_ONLY_RIGHT, LabelPlacement.TIME_ONLY_RIGHT, LabelPlacement.LABEL_ONLY_RIGHT};
        final int index;
        final Rectangle boundaries;
        String text;
        boolean mirrored;
        private final List<LabelPlacement> placements = new ArrayList<LabelPlacement>();
        private volatile ListIterator<LabelPlacement> placementIter;

        public CursorLabel(int aIndex, String aText, Rectangle aBoundaries) {
            this.index = aIndex;
            this.text = aText;
            this.boundaries = aBoundaries;
        }

        @Override
        public int compareTo(CursorLabel aLabel) {
            int result = this.boundaries.x - aLabel.boundaries.x;
            if (result == 0) {
                result = this.boundaries.width - aLabel.boundaries.width;
            }
            if (result == 0) {
                result = this.boundaries.y - aLabel.boundaries.y;
            }
            return result;
        }

        public Polygon getPolygon() {
            int x = this.boundaries.x;
            int w = this.boundaries.width;
            int y = this.boundaries.y;
            int h = this.boundaries.height;
            Polygon flagPoly = new Polygon();
            if (this.mirrored) {
                flagPoly.xpoints = new int[]{x, x + w, x + w, x + h / 3, x};
                flagPoly.ypoints = new int[]{y, y, y + h, y + h, y + 2 * h / 3};
                flagPoly.npoints = 5;
            } else {
                flagPoly.xpoints = new int[]{x, x + w, x + w, x + w - h / 3, x};
                flagPoly.ypoints = new int[]{y, y, y + 2 * h / 3, y + h, y + h};
                flagPoly.npoints = 5;
            }
            return flagPoly;
        }

        public boolean hasMoreStyles() {
            return this.placementIter.hasNext();
        }

        public boolean intersects(CursorLabel aLabel) {
            return this.boundaries.intersects(aLabel.boundaries);
        }

        public boolean isCompletelyVisible(Rectangle aClipBounds) {
            return aClipBounds.contains(this.boundaries);
        }

        public void resetStyle(Rectangle aClipBounds, TimeLineViewModel aModel, FontMetrics aFM) {
            this.placements.clear();
            for (LabelPlacement element : PLACEMENTS) {
                if (!this.isValidPlacement(element, aClipBounds, aModel, aFM)) continue;
                this.placements.add(element);
            }
            this.placementIter = this.placements.listIterator();
            this.recalculateBoundaries(aModel, aFM);
        }

        public String toString() {
            return "CursorLabel [index=" + this.index + ", boundaries=" + this.boundaries + ", text=" + this.text + "]";
        }

        public void useNextStyle(TimeLineViewModel aModel, FontMetrics aFM) {
            if (this.placementIter.hasNext()) {
                this.recalculateBoundaries(aModel, aFM);
            }
        }

        private boolean isValidPlacement(LabelPlacement labelPlacement, Rectangle aClipBounds, TimeLineViewModel aModel, FontMetrics aFM) {
            String flagText = aModel.getCursorFlagText(this.index, labelPlacement.style);
            Rectangle rect = new Rectangle(this.boundaries);
            rect.width = aFM.stringWidth(flagText) + 3;
            rect.x = aModel.getCursorScreenCoordinate(this.index);
            if (labelPlacement.mirrored) {
                rect.x = Math.max(0, rect.x - rect.width);
            }
            return aClipBounds.contains(rect);
        }

        private void recalculateBoundaries(TimeLineViewModel aModel, FontMetrics aFM) {
            String flagText;
            if (this.placementIter == null || !this.placementIter.hasNext()) {
                return;
            }
            LabelPlacement labelPlacement = this.placementIter.next();
            this.text = flagText = aModel.getCursorFlagText(this.index, labelPlacement.style);
            this.boundaries.width = aFM.stringWidth(flagText) + 3;
            this.boundaries.x = aModel.getCursorScreenCoordinate(this.index);
            this.mirrored = labelPlacement.mirrored;
            if (this.mirrored) {
                this.boundaries.x = Math.max(0, this.boundaries.x - this.boundaries.width);
            }
        }
    }
}

