/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.asm45;

import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.asm45.Asm45DataSet;
import nl.lxtreme.ols.tool.asm45.Asm45OpcodeTable;
import nl.lxtreme.ols.util.NumberUtils;

public class Asm45AnalyserTask
implements ToolTask<Asm45DataSet> {
    private static final String[] registers = new String[]{"A", "B", "P", "R", "R4", "R5", "R6", "R7", "R10", "Pa", "W", "Dmapa", "Dmama", "Dmac", "C", "D", "Ar2", "Ar2_2", "Ar2_3", "Ar2_4", "Se", "R25", "R26", "R27", "R30", "R31", "R32", "R33", "R34", "R35", "R36", "R37"};
    private static final Asm45OpcodeTable[] hp9845Table = new Asm45OpcodeTable[]{new Asm45OpcodeTable(65535, 0, "NOP", 0, 11), new Asm45OpcodeTable(65535, 61775, "CLA", 0, 11), new Asm45OpcodeTable(65535, 63823, "CLB", 0, 11), new Asm45OpcodeTable(30720, 0, "LDA", 1, 13), new Asm45OpcodeTable(30720, 2048, "LDB", 1, 13), new Asm45OpcodeTable(30720, 4096, "CPA", 1, 16), new Asm45OpcodeTable(30720, 6144, "CPB", 1, 16), new Asm45OpcodeTable(30720, 8192, "ADA", 1, 13), new Asm45OpcodeTable(30720, 10240, "ADB", 1, 13), new Asm45OpcodeTable(30720, 12288, "STA", 1, 13), new Asm45OpcodeTable(30720, 14336, "STB", 1, 13), new Asm45OpcodeTable(30720, 16384, "JSM", 1, 17), new Asm45OpcodeTable(30720, 18432, "ISZ", 1, 19), new Asm45OpcodeTable(30720, 20480, "AND", 1, 13), new Asm45OpcodeTable(30720, 22528, "DSZ", 1, 19), new Asm45OpcodeTable(30720, 24576, "IOR", 1, 13), new Asm45OpcodeTable(30720, 26624, "JMP", 1, 8), new Asm45OpcodeTable(32736, 28672, "EXE", 2, 8), new Asm45OpcodeTable(65472, 29696, "RZA", 3, 14), new Asm45OpcodeTable(65472, 31744, "RZB", 3, 14), new Asm45OpcodeTable(65472, 29760, "RIA", 3, 14), new Asm45OpcodeTable(65472, 31808, "RIB", 3, 14), new Asm45OpcodeTable(65472, 29952, "SZA", 3, 14), new Asm45OpcodeTable(65472, 32000, "SZB", 3, 14), new Asm45OpcodeTable(65472, 30016, "SIA", 3, 14), new Asm45OpcodeTable(65472, 32064, "SIB", 3, 14), new Asm45OpcodeTable(65472, 29824, "SFS", 3, 14), new Asm45OpcodeTable(65472, 30080, "SFC", 3, 14), new Asm45OpcodeTable(65472, 29888, "SDS", 3, 14), new Asm45OpcodeTable(65472, 30144, "SDC", 3, 14), new Asm45OpcodeTable(65472, 31872, "SSS", 3, 14), new Asm45OpcodeTable(65472, 32128, "SSC", 3, 14), new Asm45OpcodeTable(65472, 31936, "SHS", 3, 14), new Asm45OpcodeTable(65472, 32192, "SHC", 3, 14), new Asm45OpcodeTable(65280, 30208, "SLA", 4, 14), new Asm45OpcodeTable(65280, 32256, "SLB", 4, 14), new Asm45OpcodeTable(65280, 30464, "RLA", 4, 14), new Asm45OpcodeTable(65280, 32512, "RLB", 4, 14), new Asm45OpcodeTable(65280, 62464, "SAP", 4, 14), new Asm45OpcodeTable(65280, 64512, "SBP", 4, 14), new Asm45OpcodeTable(65280, 62720, "SAM", 4, 14), new Asm45OpcodeTable(65280, 64768, "SBM", 4, 14), new Asm45OpcodeTable(65280, 62976, "SOC", 4, 14), new Asm45OpcodeTable(65280, 63232, "SOS", 4, 14), new Asm45OpcodeTable(65280, 65024, "SEC", 4, 14), new Asm45OpcodeTable(65280, 65280, "SES", 4, 14), new Asm45OpcodeTable(65535, 61472, "TCA", 0, 9), new Asm45OpcodeTable(65535, 63520, "TCB", 0, 9), new Asm45OpcodeTable(65535, 61536, "CMA", 0, 9), new Asm45OpcodeTable(65535, 63584, "CMB", 0, 9), new Asm45OpcodeTable(65408, 61568, "RET", 5, 16), new Asm45OpcodeTable(65520, 61696, "AAR", 6, 9), new Asm45OpcodeTable(65520, 63744, "ABR", 6, 9), new Asm45OpcodeTable(65520, 61760, "SAR", 6, 9), new Asm45OpcodeTable(65520, 63808, "SBR", 6, 9), new Asm45OpcodeTable(65520, 61824, "SAL", 6, 9), new Asm45OpcodeTable(65520, 63872, "SBL", 6, 9), new Asm45OpcodeTable(65520, 61888, "RAR", 6, 9), new Asm45OpcodeTable(65520, 63936, "RBR", 6, 9), new Asm45OpcodeTable(65535, 28944, "EIR", 0, 12), new Asm45OpcodeTable(65535, 28952, "DIR", 0, 12), new Asm45OpcodeTable(65535, 28928, "SDO", 0, 12), new Asm45OpcodeTable(65535, 28936, "SDI", 0, 12), new Asm45OpcodeTable(65535, 28960, "DMA", 0, 12), new Asm45OpcodeTable(65535, 28968, "PCM", 0, 12), new Asm45OpcodeTable(65535, 28984, "DDR", 0, 12), new Asm45OpcodeTable(65535, 28992, "DBL", 0, 12), new Asm45OpcodeTable(65535, 29000, "CBL", 0, 12), new Asm45OpcodeTable(65535, 29008, "DBU", 0, 12), new Asm45OpcodeTable(65535, 29016, "CBU", 0, 12), new Asm45OpcodeTable(65400, 29024, "PWC", 7, 23), new Asm45OpcodeTable(65400, 29032, "PWD", 7, 23), new Asm45OpcodeTable(65400, 31072, "PBC", 7, 23), new Asm45OpcodeTable(65400, 31080, "PBD", 7, 23), new Asm45OpcodeTable(65400, 29040, "WWC", 7, 23), new Asm45OpcodeTable(65400, 29048, "WWD", 7, 23), new Asm45OpcodeTable(65400, 31088, "WBC", 7, 23), new Asm45OpcodeTable(65400, 31096, "WBD", 7, 23), new Asm45OpcodeTable(65520, 29568, "CLR", 6, 16), new Asm45OpcodeTable(65520, 29440, "XFR", 6, 21), new Asm45OpcodeTable(65535, 31488, "MRX", 0, 62), new Asm45OpcodeTable(65535, 31521, "DRS", 0, 56), new Asm45OpcodeTable(65535, 31585, "MLY", 0, 32), new Asm45OpcodeTable(65535, 31552, "MRY", 0, 33), new Asm45OpcodeTable(65535, 29504, "NRM", 0, 23), new Asm45OpcodeTable(65535, 29312, "FXA", 0, 40), new Asm45OpcodeTable(65535, 29184, "MWA", 0, 28), new Asm45OpcodeTable(65535, 29280, "CMX", 0, 59), new Asm45OpcodeTable(65535, 29216, "CMY", 0, 23), new Asm45OpcodeTable(65535, 31232, "FMP", 0, 42), new Asm45OpcodeTable(65535, 31265, "FDV", 0, 37), new Asm45OpcodeTable(65535, 31631, "MPY", 0, 65), new Asm45OpcodeTable(65535, 29632, "CDC", 0, 11), new Asm45OpcodeTable(0, 0, null, 0, 0)};
    private final ToolContext context;
    private final ToolProgressListener progressListener;
    private int lineSMCmask;
    private int lineSTMmask;
    private int lineEBGmask;
    private int lineBYTEmask;
    private int lineBLmask;
    private int lineWRTmask;
    private int lineSYNCmask;
    private int lineSMCidx;
    private boolean reportInst;
    private boolean reportData;
    private boolean reportBusGrants;

    public Asm45AnalyserTask(ToolContext aContext, ToolProgressListener aProgressListener, AnnotationListener aAnnotationListener) {
        this.context = aContext;
        this.progressListener = aProgressListener;
    }

    public Asm45DataSet call() throws Exception {
        AcquisitionResult data = this.context.getData();
        int[] values = data.getValues();
        int startOfDecode = this.context.getStartSampleIndex();
        int endOfDecode = this.context.getEndSampleIndex();
        Asm45DataSet asm45DataSet = new Asm45DataSet(startOfDecode, endOfDecode, data);
        int startIdx = 0;
        int status = 0;
        int clocks = 0;
        int block = 0;
        int address = 0;
        boolean busGrant = false;
        String type = "I";
        String event = "???";
        for (int idx = asm45DataSet.getStartOfDecode(); idx < asm45DataSet.getEndOfDecode() - 1; ++idx) {
            int dataValue = values[idx];
            int control = dataValue & 0xFFFF0000;
            int ida = ~dataValue & 0xFFFF;
            ++clocks;
            if ((status & this.lineSTMmask) != 0 && (control & this.lineSTMmask) == 0) {
                startIdx = idx;
                address = ida;
                block = ~control >> 16 & 0x3F;
            }
            if ((status & this.lineSMCmask) == 0 && (control & this.lineSMCmask) != 0) {
                if ((status & this.lineEBGmask) != 0 && (control & this.lineEBGmask) == 0) {
                    busGrant = true;
                    type = (status & this.lineBYTEmask) == 0 ? "DW" : ((status & this.lineBLmask) == 0 ? "DBR" : "DBL");
                    event = (status & this.lineWRTmask) != 0 ? (address < 32 ? registers[address] + String.format("&rarr;$%04x", ida) : String.format("%04x&rarr;$%04x", address, ida)) : (address < 32 ? registers[address] + String.format("&larr;$%04x", ida) : String.format("%04x&larr;$%04x", address, ida));
                } else {
                    busGrant = false;
                    if ((status & this.lineSYNCmask) != 0) {
                        type = "I";
                        event = this.word2asm(address, ida);
                    } else {
                        type = (status & this.lineBYTEmask) == 0 ? "DW" : ((status & this.lineBLmask) == 0 ? "DBR" : "DBL");
                        event = (status & this.lineWRTmask) != 0 ? (address < 32 ? registers[address] + String.format("&rarr;$%04x", ida) : String.format("%04x&rarr;$%04x", address, ida)) : (address < 32 ? registers[address] + String.format("&larr;$%04x", ida) : String.format("%04x&larr;$%04x", address, ida));
                    }
                }
                if (type == "I" && this.reportInst || !busGrant && (type == "DW" || type == "DBL" || type == "DBR") && this.reportData || busGrant && this.reportBusGrants) {
                    this.reportEvent(asm45DataSet, startIdx, idx, clocks, block, address, ida, busGrant, type, event);
                    clocks = 0;
                }
            }
            status = control;
            this.progressListener.setProgress(NumberUtils.getPercentage((int)idx, (int)startOfDecode, (int)endOfDecode));
        }
        return asm45DataSet;
    }

    public void setLineBLIndex(int aLineBLidx) {
        this.lineBLmask = 1 << aLineBLidx;
    }

    public void setLineBYTEIndex(int aLineBYTEidx) {
        this.lineBYTEmask = 1 << aLineBYTEidx;
    }

    public void setLineEBGIndex(int aLineEBGidx) {
        this.lineEBGmask = 1 << aLineEBGidx;
    }

    public void setLineSMCIndex(int aLineSMCidx) {
        this.lineSMCidx = aLineSMCidx;
        this.lineSMCmask = 1 << aLineSMCidx;
    }

    public void setLineSTMIndex(int aLineSTMidx) {
        this.lineSTMmask = 1 << aLineSTMidx;
    }

    public void setLineSYNCIndex(int aLineSYNCidx) {
        this.lineSYNCmask = 1 << aLineSYNCidx;
    }

    public void setLineWRTIndex(int aLineWRTidx) {
        this.lineWRTmask = 1 << aLineWRTidx;
    }

    public void setReportBusGrants(boolean aReportBusGrants) {
        this.reportBusGrants = aReportBusGrants;
    }

    public void setReportData(boolean aReportData) {
        this.reportData = aReportData;
    }

    public void setReportInst(boolean aReportInst) {
        this.reportInst = aReportInst;
    }

    protected String word2asm(int address, int opcode) {
        int timing = 0;
        int i = 0;
        Asm45OpcodeTable op = hp9845Table[0];
        String ret_string = "";
        while (op.getMnemonic() != null && (opcode & op.getMask()) != op.getOpcode()) {
            op = hp9845Table[++i];
        }
        if (op.getMnemonic() == null) {
            return "???";
        }
        ret_string = op.getMnemonic();
        timing = op.getTiming();
        switch (op.getMode()) {
            case 0: {
                break;
            }
            case 1: {
                int operand = opcode & 0x3FF;
                if ((opcode & 0x200) != 0) {
                    operand -= 1024;
                }
                ret_string = (opcode & 0x400) != 0 ? ret_string + String.format(" %04x", address + operand) : (operand < 0 ? ret_string + String.format(" %04x", 65536 + operand) : (operand < 32 ? ret_string + String.format(" %s", registers[operand]) : ret_string + String.format(" %04x", operand)));
                if ((opcode & 0x8000) != 0) {
                    timing += 6;
                    ret_string = ret_string + ",I";
                }
                if ((opcode & 0x400) != 0 || operand >= 0 && operand <= 31) break;
                ret_string = ret_string + " [B]";
                break;
            }
            case 2: {
                int operand = opcode & 0x1F;
                ret_string = ret_string + String.format(" %s", registers[operand]);
                if ((opcode & 0x8000) == 0) break;
                timing += 6;
                ret_string = ret_string + ",I";
                break;
            }
            case 3: {
                int operand = opcode & 0x3F;
                if ((opcode & 0x20) != 0) {
                    operand -= 64;
                }
                ret_string = ret_string + String.format(" *+%d [%04x]", operand, address + operand);
                break;
            }
            case 4: {
                int operand = opcode & 0x3F;
                if ((opcode & 0x20) != 0) {
                    operand -= 64;
                }
                ret_string = ret_string + String.format(" *+%d", operand);
                if ((opcode & 0x80) != 0) {
                    ret_string = (opcode & 0x40) != 0 ? ret_string + ",S" : ret_string + ",C";
                }
                ret_string = ret_string + String.format(" [%04x]", address + operand);
                break;
            }
            case 5: {
                int operand = opcode & 0x3F;
                if ((opcode & 0x20) != 0) {
                    operand -= 64;
                }
                ret_string = ret_string + String.format(" %d", operand);
                if ((opcode & 0x40) == 0) break;
                ret_string = ret_string + ",P";
                break;
            }
            case 6: {
                int count = (opcode & 0xF) + 1;
                ret_string = ret_string + String.format(" %d", count);
                if ((opcode & 0xFFF0) == 29568) {
                    timing += count * 6;
                    break;
                }
                if ((opcode & 0xFFF0) == 29568) {
                    timing += count * 12;
                    break;
                }
                timing += count;
                break;
            }
            case 7: {
                int operand = opcode & 7;
                ret_string = ret_string + String.format(" %s", registers[operand]);
                ret_string = (opcode & 0x80) != 0 ? ret_string + ",D" : ret_string + ",I";
            }
        }
        assert (timing >= 0);
        return ret_string;
    }

    private void reportEvent(Asm45DataSet aDataSet, int aStartSampleIdx, int aEndSampleIdx, int aClocks, int aBlock, int aAddress, int aValue, boolean aBusGrant, String aType, String aEvent) {
        aDataSet.reportEvent(this.lineSMCidx, aStartSampleIdx, aEndSampleIdx, aClocks, aBlock, aAddress, aValue, aBusGrant, aType, aEvent);
    }
}

