/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.onewire;

import nl.lxtreme.ols.tool.onewire.OneWireBusMode;

final class OneWireTiming {
    private final double aMin;
    private final double aMax;
    private final double bMin;
    private final double cMin;
    private final double cMax;
    private final double dMin;
    private final double eMax;
    private final double gMin;
    private final double hMin;
    private final double hMax;
    private final double iMin;
    private final double iMax;
    private final double jMin;

    public OneWireTiming(OneWireBusMode aMode) {
        if (OneWireBusMode.STANDARD == aMode) {
            this.aMin = 3.0;
            this.aMax = 15.0;
            this.bMin = 59.0;
            this.cMin = 60.0;
            this.cMax = 120.0;
            this.dMin = 5.3;
            this.eMax = 9.3;
            this.gMin = 0.0;
            this.hMin = 480.0;
            this.hMax = 640.0;
            this.iMin = 60.3;
            this.iMax = 75.3;
            this.jMin = 410.0;
        } else if (OneWireBusMode.OVERDRIVE == aMode) {
            this.aMin = 1.0;
            this.aMax = 2.0;
            this.bMin = 8.0;
            this.cMin = 7.0;
            this.cMax = 14.0;
            this.dMin = 2.3;
            this.eMax = 1.2;
            this.gMin = 2.5;
            this.hMin = 68.0;
            this.hMax = 80.0;
            this.iMin = 7.0;
            this.iMax = 9.3;
            this.jMin = 39.5;
        } else {
            throw new RuntimeException("Unknown bus mode: " + (Object)((Object)aMode));
        }
    }

    public double getBitFrameLength() {
        return Math.max(this.aMin + this.bMin, this.cMin + this.dMin) - 1.0;
    }

    public double getResetFrameLength() {
        return this.gMin + this.hMin + this.iMin + this.jMin - 1.0;
    }

    public boolean isOne(double aTimeValue) {
        return aTimeValue >= this.aMin && aTimeValue < this.aMax + this.eMax - 1.0;
    }

    public boolean isReset(double aTimeValue) {
        return aTimeValue >= this.hMin && aTimeValue <= this.hMax;
    }

    public boolean isSlavePresencePulse(double aTimeValue) {
        return aTimeValue <= this.iMax;
    }

    public boolean isZero(double aTimeValue) {
        return aTimeValue >= this.aMax + this.eMax && aTimeValue <= this.cMax;
    }
}

