/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer.sampleprocessor;

import org.sump.device.logicsniffer.LogicSnifferConfig;
import org.sump.device.logicsniffer.sampleprocessor.SampleProcessor;
import org.sump.device.logicsniffer.sampleprocessor.SampleProcessorCallback;

public final class EqualityFilter
implements SampleProcessor {
    private final LogicSnifferConfig config;
    private final int[] buffer;
    private final int trigCount;
    private final SampleProcessorCallback callback;

    public EqualityFilter(LogicSnifferConfig aConfig, int[] aBuffer, int aTrigCount, SampleProcessorCallback aCallback) {
        if (aBuffer == null) {
            throw new IllegalArgumentException("Buffer cannot be null!");
        }
        this.config = aConfig;
        this.buffer = aBuffer;
        this.trigCount = aTrigCount;
        this.callback = aCallback;
    }

    @Override
    public final void process() {
        long time = 0L;
        int samples = this.buffer.length;
        int lastSample = 0;
        for (int i = 0; i < samples; ++i) {
            int newSample = this.buffer[i];
            if (i == 0 || lastSample != newSample) {
                this.callback.addValue(newSample, time);
            }
            lastSample = newSample;
            ++time;
        }
        this.callback.addValue(lastSample, time);
        int correction = 2;
        if (this.config.getDivider() <= 3) {
            correction = 1;
        }
        this.callback.ready(time - 1L, this.trigCount - correction);
    }
}

