/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.drag;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListenerAdapter;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class RepresentativeAnchorDragListener
extends DragListenerAdapter {
    protected ToolWindowAnchor lastAnchor;
    protected Component component;

    public RepresentativeAnchorDragListener(DockableDescriptor descriptor, Component component) {
        super(descriptor);
        this.component = component;
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        super.dragGestureRecognized(dge);
        if (!this.acquireLocks()) {
            return;
        }
        dge.startDrag(DragSource.DefaultMoveDrop, this.createTransferable(), this);
        this.descriptor.getToolBar().propertyChange(new PropertyChangeEvent(this.getComponent(), "startDrag", null, dge));
        if (SwingUtil.getBoolean("drag.icon.useDefault", false)) {
            this.setGhostImage(dge.getDragOrigin(), SwingUtil.getImage("mydoggy.image.drag"));
        } else {
            JComponent representativeAnchor = this.descriptor.getRepresentativeAnchor();
            BufferedImage ghostImage = new BufferedImage(representativeAnchor.getWidth(), representativeAnchor.getHeight(), 1);
            representativeAnchor.print(ghostImage.createGraphics());
            this.setGhostImage(dge.getDragOrigin(), ghostImage);
        }
        this.lastAnchor = null;
    }

    public void dragMouseMoved(DragSourceDragEvent dsde) {
        if (!this.checkStatus()) {
            return;
        }
        ToolWindowAnchor newAnchor = this.manager.getToolWindowAnchor(dsde.getLocation());
        if (newAnchor != this.lastAnchor) {
            if (!SwingUtil.getBoolean("drag.icon.useDefault", false)) {
                this.resetGhostImage();
                if (newAnchor == null) {
                    this.updatedGhostImage = this.ghostImage;
                    this.manager.getBar(this.lastAnchor).setTemporarilyVisible(false);
                } else {
                    if (this.manager.getBar(newAnchor).getAvailableTools() == 0) {
                        this.manager.getBar(newAnchor).setTemporarilyVisible(true);
                    }
                    block0 : switch (newAnchor) {
                        case LEFT: {
                            switch (this.descriptor.getAnchor()) {
                                case LEFT: {
                                    this.updatedGhostImage = this.ghostImage;
                                    break block0;
                                }
                                case RIGHT: {
                                    this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, Math.PI);
                                    break block0;
                                }
                            }
                            this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, 4.71238898038469);
                            break;
                        }
                        case RIGHT: {
                            switch (this.descriptor.getAnchor()) {
                                case LEFT: {
                                    this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, Math.PI);
                                    break block0;
                                }
                                case RIGHT: {
                                    this.updatedGhostImage = this.ghostImage;
                                    break block0;
                                }
                            }
                            this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, -4.71238898038469);
                            break;
                        }
                        case TOP: 
                        case BOTTOM: {
                            switch (this.descriptor.getAnchor()) {
                                case LEFT: {
                                    this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, -4.71238898038469);
                                    break block0;
                                }
                                case RIGHT: {
                                    this.updatedGhostImage = GraphicsUtil.rotate(this.ghostImage, 4.71238898038469);
                                    break block0;
                                }
                            }
                            this.updatedGhostImage = this.ghostImage;
                        }
                    }
                }
            } else {
                this.updatedGhostImage = this.ghostImage;
            }
            this.lastAnchor = newAnchor;
        }
        this.updateGhostImage(dsde.getLocation(), this.updatedGhostImage);
        this.updateDropTarget(dsde);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dragDropEnd(DragSourceDropEvent dsde) {
        block4: {
            block3: {
                try {
                    if (!this.checkStatus()) {
                        Object var3_2 = null;
                        break block3;
                    }
                    this.releaseLocksOne();
                    this.manager.setBarsTemporarilyVisible(false);
                    this.descriptor.getToolBar().propertyChange(new PropertyChangeEvent(this.getComponent(), "endDrag", null, dsde));
                    this.cleanupGhostImage();
                    this.lastAnchor = null;
                    this.releaseLocksTwo();
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.dockableDropDragEnd();
                    throw throwable;
                }
            }
            this.dockableDropDragEnd();
            return;
        }
        Object var3_3 = null;
        this.dockableDropDragEnd();
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    protected Transferable createTransferable() {
        return new MyDoggyTransferable(this.manager, MyDoggyTransferable.CUSTOM_DESCRIPTOR_ID, this.descriptor.getDockable().getId());
    }
}

