/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.noos.xing.mydoggy.ToolWindowAnchor;

public class SlidingBorder
implements Border {
    private ToolWindowAnchor anchor;
    private Border border = BorderFactory.createRaisedBevelBorder();

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        switch (this.anchor) {
            case LEFT: {
                this.border.paintBorder(c, g, x + c.getWidth() - 5, y, 5, height);
                break;
            }
            case RIGHT: {
                this.border.paintBorder(c, g, x, y, 5, height);
                break;
            }
            case TOP: {
                this.border.paintBorder(c, g, x, y + c.getHeight() - 5, width, 5);
                break;
            }
            case BOTTOM: {
                this.border.paintBorder(c, g, x, y, width, 5);
            }
        }
    }

    public Insets getBorderInsets(Component c) {
        switch (this.anchor) {
            case LEFT: {
                return new Insets(0, 0, 0, 5);
            }
            case RIGHT: {
                return new Insets(0, 5, 0, 0);
            }
            case TOP: {
                return new Insets(0, 0, 5, 0);
            }
            case BOTTOM: {
                return new Insets(5, 0, 0, 0);
            }
        }
        throw new IllegalStateException();
    }

    public void setAnchor(ToolWindowAnchor anchor) {
        this.anchor = anchor;
    }
}

