/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;

public class Scanner {
    final File directory;
    final FilenameFilter filter;
    Map lastChecksums = new HashMap();
    Map storedChecksums = new HashMap();

    public Scanner(File directory) {
        this(directory, null);
    }

    public Scanner(File directory, FilenameFilter filter) {
        this.directory = Scanner.canon(directory);
        this.filter = filter;
    }

    public void initialize(Map checksums) {
        this.storedChecksums.putAll(checksums);
    }

    public Set scan(boolean reportImmediately) {
        File file;
        File[] list = this.directory.listFiles(this.filter);
        if (list == null) {
            return null;
        }
        HashSet<File> files = new HashSet<File>();
        HashSet removed = new HashSet(this.storedChecksums.keySet());
        for (int i = 0; i < list.length; ++i) {
            file = list[i];
            long lastChecksum = this.lastChecksums.get(file) != null ? (Long)this.lastChecksums.get(file) : 0L;
            long storedChecksum = this.storedChecksums.get(file) != null ? (Long)this.storedChecksums.get(file) : 0L;
            long newChecksum = Scanner.checksum(file);
            this.lastChecksums.put(file, new Long(newChecksum));
            if ((newChecksum == lastChecksum || reportImmediately) && newChecksum != storedChecksum) {
                this.storedChecksums.put(file, new Long(newChecksum));
                files.add(file);
            }
            removed.remove(file);
        }
        Iterator it = removed.iterator();
        while (it.hasNext()) {
            file = (File)it.next();
            files.addAll(removed);
            this.lastChecksums.remove(file);
            this.storedChecksums.remove(file);
        }
        return files;
    }

    private static File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public long getChecksum(File file) {
        Long c = (Long)this.storedChecksums.get(file);
        return c != null ? c : 0L;
    }

    public void updateChecksum(File file) {
        if (file != null && this.storedChecksums.containsKey(file)) {
            long newChecksum = Scanner.checksum(file);
            this.storedChecksums.put(file, new Long(newChecksum));
        }
    }

    static long checksum(File file) {
        CRC32 crc = new CRC32();
        Scanner.checksum(file, crc);
        return crc.getValue();
    }

    private static void checksum(File file, CRC32 crc) {
        File[] children;
        crc.update(file.getName().getBytes());
        if (file.isFile()) {
            Scanner.checksum(file.lastModified(), crc);
            Scanner.checksum(file.length(), crc);
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                Scanner.checksum(children[i], crc);
            }
        }
    }

    private static void checksum(long l, CRC32 crc) {
        for (int i = 0; i < 8; ++i) {
            crc.update((int)(l & 0xFFL));
            l >>= 8;
        }
    }
}

