/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.spi;

import nl.lxtreme.ols.api.data.BaseData;

public final class SPIData
extends BaseData<SPIData> {
    private final int dataValue;
    private final String dataName;

    public SPIData(int aIdx, int aChannelIdx, String aEvent, int aSampleIdx) {
        super(aIdx, aChannelIdx, aSampleIdx, aEvent);
        this.dataValue = 0;
        this.dataName = null;
    }

    public SPIData(int aIdx, int aChannelIdx, String aDataName, int aDataValue, int aStartSampleIdx, int aEndSampleIdx) {
        super(aIdx, aChannelIdx, aStartSampleIdx, aEndSampleIdx);
        this.dataName = aDataName;
        this.dataValue = aDataValue;
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (!super.equals(aObject) || !(aObject instanceof SPIData)) {
            return false;
        }
        SPIData other = (SPIData)((Object)aObject);
        return this.dataValue == other.dataValue;
    }

    public String getDataName() {
        return this.dataName;
    }

    public final int getDataValue() {
        return this.dataValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.dataValue;
        return result;
    }

    public boolean isData() {
        return this.dataName != null && !this.dataName.trim().isEmpty();
    }

    public final boolean isMisoData() {
        return "MISO".equals(this.dataName);
    }

    public final boolean isMosiData() {
        return "MOSI".equals(this.dataName);
    }
}

