/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer.protocol;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.util.HostUtils;
import org.sump.device.logicsniffer.LogicSnifferConfig;
import org.sump.device.logicsniffer.LogicSnifferMetadata;
import org.sump.device.logicsniffer.protocol.SumpProtocolConstants;

public class SumpResultReader
implements Closeable,
SumpProtocolConstants {
    private static final Logger LOG = Logger.getLogger(SumpResultReader.class.getName());
    private final LogicSnifferConfig config;
    private final DataInputStream inputStream;

    public SumpResultReader(LogicSnifferConfig aConfiguration, DataInputStream aInputStream) {
        this.config = aConfiguration;
        this.inputStream = aInputStream;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public void flush() throws IOException {
        if (this.inputStream != null) {
            while (this.inputStream.available() > 0 && this.inputStream.read() >= 0) {
            }
        }
    }

    public int readDeviceId() throws IOException {
        int id = this.inputStream.readInt();
        if (id == 809585747) {
            LOG.log(Level.INFO, "Found (unsupported!) Sump Logic Analyzer ...", Integer.toHexString(id));
        } else if (id == 826362963) {
            LOG.log(Level.INFO, "Found Sump Logic Analyzer/LogicSniffer compatible device ...", Integer.toHexString(id));
        } else {
            LOG.log(Level.INFO, "Found unknown device: 0x{0} ...", Integer.toHexString(id));
            id = -1;
        }
        return id;
    }

    public boolean readMetadata(LogicSnifferMetadata aMetadata) throws IOException, IllegalStateException {
        boolean gotResponse = false;
        int result = -1;
        do {
            try {
                result = this.inputStream.read();
                if (result <= 0) continue;
                gotResponse = true;
                int type = (result & 0xE0) >> 5;
                if (type == 0) {
                    String value = this.readString();
                    aMetadata.put(result, value);
                    continue;
                }
                if (type == 1) {
                    int value = this.inputStream.readInt();
                    aMetadata.put(result, value);
                    continue;
                }
                if (type == 2) {
                    int value = this.inputStream.read();
                    aMetadata.put(result, value);
                    continue;
                }
                LOG.log(Level.INFO, "Ignoring unknown metadata type: {0}", type);
            }
            catch (IOException exception) {
                result = -1;
                if (HostUtils.handleInterruptedException((Throwable)exception)) continue;
                LOG.log(Level.INFO, "I/O exception", exception);
            }
        } while (result > 0 && !Thread.currentThread().isInterrupted());
        return gotResponse;
    }

    public int readSample() throws IOException {
        int read;
        int groupCount = this.config.getGroupCount();
        byte[] buf = new byte[groupCount];
        int enabledGroupCount = this.config.getEnabledGroupCount();
        assert (enabledGroupCount > 0) : "Internal error: enabled group count should be at least 1!";
        assert (enabledGroupCount <= groupCount) : "Internal error: enabled group count be at most " + groupCount;
        int offset = 0;
        do {
            if ((read = this.inputStream.read(buf, offset, enabledGroupCount - offset)) >= 0) continue;
            throw new EOFException("Data readout interrupted: EOF.");
        } while (!Thread.currentThread().isInterrupted() && (offset += read) < enabledGroupCount);
        int value = 0;
        int j = 0;
        for (int i = 0; i < groupCount; ++i) {
            if (!this.config.isGroupEnabled(i)) continue;
            value |= (buf[j++] & 0xFF) << 8 * i;
        }
        return value;
    }

    final String readString() throws IOException {
        StringBuilder sb = new StringBuilder();
        int read = -1;
        do {
            if ((read = this.inputStream.read()) <= 0) continue;
            sb.append((char)read);
        } while (read > 0 && !Thread.currentThread().isInterrupted());
        return sb.toString();
    }
}

