/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer.profile;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.StringUtils;

public final class DeviceProfile
implements Cloneable {
    public static final String DEVICE_TYPE = "device.type";
    public static final String DEVICE_DESCRIPTION = "device.description";
    public static final String DEVICE_INTERFACE = "device.interface";
    public static final String DEVICE_CLOCKSPEED = "device.clockspeed";
    public static final String DEVICE_SUPPORTS_DDR = "device.supports_ddr";
    public static final String DEVICE_SAMPLERATES = "device.samplerates";
    public static final String DEVICE_CAPTURECLOCK = "device.captureclock";
    public static final String DEVICE_CAPTURESIZES = "device.capturesizes";
    public static final String DEVICE_FEATURE_NOISEFILTER = "device.feature.noisefilter";
    public static final String DEVICE_FEATURE_RLE = "device.feature.rle";
    public static final String DEVICE_FEATURE_TEST_MODE = "device.feature.testmode";
    public static final String DEVICE_FEATURE_TRIGGERS = "device.feature.triggers";
    public static final String DEVICE_TRIGGER_STAGES = "device.trigger.stages";
    public static final String DEVICE_TRIGGER_COMPLEX = "device.trigger.complex";
    public static final String DEVICE_CHANNEL_COUNT = "device.channel.count";
    public static final String DEVICE_CHANNEL_GROUPS = "device.channel.groups";
    public static final String DEVICE_CAPTURESIZE_BOUND = "device.capturesize.bound";
    public static final String DEVICE_CHANNEL_NUMBERING_SCHEMES = "device.channel.numberingschemes";
    public static final String DEVICE_OPEN_PORT_DELAY = "device.open.portdelay";
    public static final String DEVICE_RECEIVE_TIMEOUT = "device.receive.timeout";
    public static final String DEVICE_METADATA_KEYS = "device.metadata.keys";
    public static final String DEVICE_SAMPLE_REVERSE_ORDER = "device.samples.reverseOrder";
    public static final String DEVICE_OPEN_PORT_DTR = "device.open.portdtr";
    public static final String FELIX_FILEINSTALL_FILENAME = "felix.fileinstall.filename";
    private static final String FELIX_SERVICE_PID = "service.pid";
    private static final String FELIX_SERVICE_FACTORY_PID = "service.factoryPid";
    private static final List<String> KNOWN_KEYS = Arrays.asList("device.type", "device.description", "device.interface", "device.clockspeed", "device.supports_ddr", "device.samplerates", "device.captureclock", "device.capturesizes", "device.feature.noisefilter", "device.feature.rle", "device.feature.testmode", "device.feature.triggers", "device.trigger.stages", "device.trigger.complex", "device.channel.count", "device.channel.groups", "device.capturesize.bound", "device.channel.numberingschemes", "device.open.portdelay", "device.metadata.keys", "device.samples.reverseOrder", "device.open.portdtr", "device.receive.timeout", "felix.fileinstall.filename");
    private static final List<String> IGNORED_KEYS = Arrays.asList("service.pid", "service.factoryPid");
    private static final Logger LOG = Logger.getLogger(DeviceProfile.class.getName());
    private final ConcurrentMap<String, String> properties = new ConcurrentHashMap<String, String>();

    static final File createFile(String aFilename) {
        if (aFilename == null) {
            throw new IllegalArgumentException("Filename cannot be null!");
        }
        return new File(aFilename.replaceAll("^file:", ""));
    }

    public DeviceProfile clone() {
        try {
            DeviceProfile clone = (DeviceProfile)super.clone();
            clone.properties.putAll(this.properties);
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || !(aObject instanceof DeviceProfile)) {
            return false;
        }
        DeviceProfile other = (DeviceProfile)aObject;
        return this.properties.equals(other.properties);
    }

    public CaptureClockSource[] getCaptureClock() {
        String rawValue = (String)this.properties.get(DEVICE_CAPTURECLOCK);
        String[] values = rawValue.split(",\\s*");
        CaptureClockSource[] result = new CaptureClockSource[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = CaptureClockSource.valueOf(values[i].trim());
        }
        return result;
    }

    public Integer[] getCaptureSizes() {
        String rawValue = (String)this.properties.get(DEVICE_CAPTURESIZES);
        String[] values = rawValue.split(",\\s*");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String value : values) {
            result.add(Integer.valueOf(value.trim()));
        }
        Collections.sort(result, NumberUtils.createNumberComparator((boolean)false));
        return result.toArray(new Integer[result.size()]);
    }

    public int getChannelCount() {
        String value = (String)this.properties.get(DEVICE_CHANNEL_COUNT);
        return Integer.parseInt(value);
    }

    public int getChannelGroupCount() {
        String value = (String)this.properties.get(DEVICE_CHANNEL_GROUPS);
        return Integer.parseInt(value);
    }

    public NumberingScheme[] getChannelNumberingSchemes() {
        String rawValue = (String)this.properties.get(DEVICE_CHANNEL_NUMBERING_SCHEMES);
        String[] values = rawValue.split(",\\s*");
        NumberingScheme[] result = new NumberingScheme[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = NumberingScheme.valueOf(values[i].trim());
        }
        return result;
    }

    public int getClockspeed() {
        String value = (String)this.properties.get(DEVICE_CLOCKSPEED);
        return Integer.parseInt(value);
    }

    public String getDescription() {
        String result = (String)this.properties.get(DEVICE_DESCRIPTION);
        return result == null ? "" : result;
    }

    public String[] getDeviceMetadataKeys() {
        String rawValue = (String)this.properties.get(DEVICE_METADATA_KEYS);
        return StringUtils.tokenizeQuotedStrings((String)rawValue, (String)", ");
    }

    public DeviceInterface getInterface() {
        String value = (String)this.properties.get(DEVICE_INTERFACE);
        return DeviceInterface.valueOf(value);
    }

    public int getMaximumCaptureSizeFor(int aChannelGroups) {
        Integer[] sizes = this.getCaptureSizes();
        if (sizes == null || sizes.length == 0 || aChannelGroups == 0) {
            return -1;
        }
        int maxSize = sizes[0];
        if (this.isCaptureSizeBoundToEnabledChannels()) {
            int indication = maxSize / aChannelGroups;
            Integer result = null;
            for (int i = sizes.length - 1; i >= 0; --i) {
                if (sizes[i].compareTo(indication) > 0) continue;
                result = sizes[i];
            }
            return result == null ? indication : result;
        }
        return maxSize;
    }

    public int getOpenPortDelay() {
        String value = (String)this.properties.get(DEVICE_OPEN_PORT_DELAY);
        return Integer.parseInt(value);
    }

    public Integer getReceiveTimeout() {
        String value = (String)this.properties.get(DEVICE_RECEIVE_TIMEOUT);
        if (value == null) {
            return null;
        }
        int timeout = Integer.parseInt(value);
        return timeout <= 0 ? null : Integer.valueOf(timeout);
    }

    public Integer[] getSampleRates() {
        String rawValue = (String)this.properties.get(DEVICE_SAMPLERATES);
        String[] values = rawValue.split(",\\s*");
        TreeSet<Integer> result = new TreeSet<Integer>(NumberUtils.createNumberComparator((boolean)false));
        for (String value : values) {
            result.add(Integer.valueOf(value.trim()));
        }
        return result.toArray(new Integer[result.size()]);
    }

    public int getTriggerStages() {
        String value = (String)this.properties.get(DEVICE_TRIGGER_STAGES);
        return Integer.parseInt(value);
    }

    public String getType() {
        String result = (String)this.properties.get(DEVICE_TYPE);
        return result == null ? "<unknown>" : result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean isCaptureSizeBoundToEnabledChannels() {
        String value = (String)this.properties.get(DEVICE_CAPTURESIZE_BOUND);
        return Boolean.parseBoolean(value);
    }

    public boolean isComplexTriggersSupported() {
        String value = (String)this.properties.get(DEVICE_TRIGGER_COMPLEX);
        return Boolean.parseBoolean(value);
    }

    public boolean isDoubleDataRateSupported() {
        String value = (String)this.properties.get(DEVICE_SUPPORTS_DDR);
        return Boolean.parseBoolean(value);
    }

    public boolean isNoiseFilterSupported() {
        String value = (String)this.properties.get(DEVICE_FEATURE_NOISEFILTER);
        return Boolean.parseBoolean(value);
    }

    public boolean isOpenPortDtr() {
        String value = (String)this.properties.get(DEVICE_OPEN_PORT_DTR);
        return Boolean.parseBoolean(value);
    }

    public boolean isRleSupported() {
        String value = (String)this.properties.get(DEVICE_FEATURE_RLE);
        return Boolean.parseBoolean(value);
    }

    public boolean isSamplesInReverseOrder() {
        String rawValue = (String)this.properties.get(DEVICE_SAMPLE_REVERSE_ORDER);
        return Boolean.parseBoolean(rawValue);
    }

    public boolean isTestModeSupported() {
        String value = (String)this.properties.get(DEVICE_FEATURE_TEST_MODE);
        return Boolean.parseBoolean(value);
    }

    public boolean isTriggerSupported() {
        String value = (String)this.properties.get(DEVICE_FEATURE_TRIGGERS);
        return Boolean.parseBoolean(value);
    }

    public String toString() {
        return this.getType();
    }

    final File getConfigurationFile() {
        String value = (String)this.properties.get(FELIX_FILEINSTALL_FILENAME);
        assert (value != null) : "Internal error: no fileinstall filename?!";
        return DeviceProfile.createFile(value);
    }

    final Dictionary<String, String> getProperties() {
        return new Hashtable<String, String>(this.properties);
    }

    final void setProperties(Dictionary aProperties) {
        HashMap<String, String> newProps = new HashMap<String, String>();
        Enumeration keys = aProperties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!KNOWN_KEYS.contains(key) && !IGNORED_KEYS.contains(key)) {
                LOG.log(Level.WARNING, "Unknown/unsupported profile key: " + key);
                continue;
            }
            String value = aProperties.get(key).toString();
            newProps.put(key, value.trim());
        }
        ArrayList<String> checkedKeys = new ArrayList<String>(KNOWN_KEYS);
        checkedKeys.removeAll(newProps.keySet());
        if (!checkedKeys.isEmpty()) {
            throw new IllegalArgumentException("Profile settings not complete! Missing keys are: " + ((Object)checkedKeys).toString());
        }
        this.properties.putAll(newProps);
        LOG.log(Level.INFO, "New device profile settings applied for {1} ({0}) ...", new Object[]{this.getType(), this.getDescription()});
    }

    public static enum TriggerType {
        SIMPLE,
        COMPLEX;

    }

    public static enum NumberingScheme {
        DEFAULT,
        INSIDE,
        OUTSIDE;

    }

    public static enum DeviceInterface {
        SERIAL,
        NETWORK,
        USB;

    }

    public static enum CaptureClockSource {
        INTERNAL,
        EXTERNAL_FALLING,
        EXTERNAL_RISING;

    }
}

