/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.state;

import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.CapturedData;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;

public class StateAnalysisTask
implements ToolTask<AcquisitionResult> {
    private static final Logger LOG = Logger.getLogger(StateAnalysisTask.class.getName());
    private final ToolContext context;
    private int number;
    private int level;

    public StateAnalysisTask(ToolContext aContext) {
        this.context = aContext;
    }

    public CapturedData call() throws Exception {
        int current;
        AcquisitionResult data = this.context.getData();
        int[] values = data.getValues();
        long triggerPosition = data.getTriggerPosition();
        int maskValue = 1 << this.number;
        int size = 0;
        int last = (values[0] & maskValue) >> this.number;
        for (int value : values) {
            current = (value & maskValue) >> this.number;
            if (last == this.level && current != this.level) {
                ++size;
            }
            last = current;
        }
        if (size <= 0) {
            LOG.log(Level.WARNING, "No state changes found in data; aborting analysis...");
            throw new IllegalStateException("No state changes found!");
        }
        last = values[0] & maskValue;
        int pos = 0;
        int newTrigger = -1;
        int[] newValues = new int[size];
        for (int i = 0; i < values.length; ++i) {
            current = (values[i] & maskValue) >> this.number;
            if (last == this.level && current != this.level) {
                newValues[pos++] = values[i - 1];
            }
            if (triggerPosition == (long)i) {
                newTrigger = pos;
            }
            last = current;
        }
        CapturedData newCapturedData = new CapturedData(newValues, (long)newTrigger, -1, data.getChannels(), data.getEnabledChannels());
        return newCapturedData;
    }

    public void setLevel(int aLevel) {
        this.level = aLevel;
    }

    public void setNumber(int aNumber) {
        this.number = aNumber;
    }
}

