/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.testsuite.TestBase;

public class Test6
extends TestBase {
    private static Exception m_Exception = null;
    private static Thread m_Receiver;
    private static Thread m_Transmitter;

    static void run() throws Exception {
        try {
            Test6.begin("Test6 - threshold + timeout");
            Test6.openPort();
            m_Receiver = new Thread(new Runnable(){

                public void run() {
                    try {
                        Test6.sync(2);
                        m_Port.enableReceiveThreshold(4);
                        m_Port.enableReceiveTimeout(1000);
                        long T0 = System.currentTimeMillis();
                        byte[] b = new byte[8];
                        int n = m_In.read(b);
                        long dT = System.currentTimeMillis() - T0;
                        if (n != 4) {
                            Test6.fail("read did not get 4 bytes as expected, got %d ", n);
                        }
                        if (dT >= 1000L) {
                            Test6.fail("read timed out though we got 4 bytes", new Object[0]);
                        }
                    }
                    catch (InterruptedException T0) {
                    }
                    catch (Exception e) {
                        if (m_Exception == null) {
                            m_Exception = e;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Transmitter = new Thread(new Runnable(){

                public void run() {
                    try {
                        Test6.sync(2);
                        m_Out.write(new byte[4]);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (m_Exception == null) {
                            m_Exception = e;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Receiver.start();
            m_Transmitter.start();
            while (m_Receiver.isAlive() || m_Transmitter.isAlive()) {
                Test6.sleep(100);
            }
            if (m_Exception != null) {
                throw m_Exception;
            }
            Test6.finishedOK();
        }
        finally {
            Test6.closePort();
        }
    }
}

