/*
 * Decompiled with CFR 0.152.
 */
package jtermios.testsuite;

import java.util.List;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Termios;
import jtermios.TimeVal;

public class JTermiosDemo {
    private static void fail(String msg) {
        System.out.println("Fail: " + msg);
        System.exit(0);
    }

    public static void main(String[] args) {
        System.out.println("JTermio simple loopback demo");
        List<String> portlist = JTermios.getPortList();
        String port = "COM5:";
        for (String pname : portlist) {
            System.out.println("Found port " + pname);
            port = pname;
        }
        int fd = JTermios.open(port, JTermios.O_RDWR | JTermios.O_NOCTTY | JTermios.O_NONBLOCK);
        if (fd == -1) {
            JTermiosDemo.fail("Could not open " + port);
        }
        JTermios.fcntl(fd, JTermios.F_SETFL, 0);
        Termios opts = new Termios();
        JTermios.tcgetattr(fd, opts);
        opts.c_lflag &= ~(JTermios.ICANON | JTermios.ECHO | JTermios.ECHOE | JTermios.ISIG);
        opts.c_cflag |= JTermios.CLOCAL | JTermios.CREAD;
        opts.c_cflag &= ~JTermios.PARENB;
        opts.c_cflag |= JTermios.CSTOPB;
        opts.c_cflag &= ~JTermios.CSIZE;
        opts.c_cflag |= JTermios.CS8;
        opts.c_oflag &= ~JTermios.OPOST;
        opts.c_iflag &= ~JTermios.INPCK;
        opts.c_iflag &= ~(JTermios.IXON | JTermios.IXOFF | JTermios.IXANY);
        opts.c_cc[JTermios.VMIN] = 0;
        opts.c_cc[JTermios.VTIME] = 10;
        JTermios.cfsetispeed(opts, JTermios.B9600);
        JTermios.cfsetospeed(opts, JTermios.B9600);
        JTermios.tcsetattr(fd, JTermios.TCSANOW, opts);
        JTermios.tcflush(fd, JTermios.TCIOFLUSH);
        byte[] tx = "Not so very long text string".getBytes();
        byte[] rx = new byte[tx.length];
        int l = tx.length;
        int n = JTermios.write(fd, tx, l);
        if (n < 0) {
            System.out.println("write() failed ");
            System.exit(0);
        }
        System.out.println("Transmitted '" + new String(tx) + "' len=" + n);
        FDSet rdset = JTermios.newFDSet();
        JTermios.FD_ZERO(rdset);
        JTermios.FD_SET(fd, rdset);
        TimeVal tout = new TimeVal();
        tout.tv_sec = 10L;
        byte[] buffer = new byte[1024];
        while (l > 0) {
            int m;
            int s = JTermios.select(fd + 1, rdset, null, null, tout);
            if (s < 0) {
                System.out.println("select() failed ");
                System.exit(0);
            }
            if ((m = JTermios.read(fd, buffer, l)) < 0) {
                System.out.println("read() failed ");
                System.exit(0);
            }
            System.arraycopy(buffer, 0, rx, rx.length - l, m);
            l -= m;
        }
        System.out.println("Received    '" + new String(rx) + "'");
        int ec = JTermios.close(fd);
    }
}

