/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.io.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.microedition.io.SocketConnection;

final class SocketConnectionImpl
implements SocketConnection {
    private static final int YES = 1;
    private static final int NO = 0;
    private final Socket socket;

    public SocketConnectionImpl(Socket aSocket) throws IllegalArgumentException {
        if (aSocket == null) {
            throw new IllegalArgumentException("Parameter socket cannot be null!");
        }
        this.socket = aSocket;
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public String getAddress() throws IOException {
        return this.socket.getInetAddress().getHostAddress();
    }

    @Override
    public String getLocalAddress() throws IOException {
        return this.socket.getLocalAddress().getHostAddress();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.socket.getLocalPort();
    }

    @Override
    public int getPort() throws IOException {
        return this.socket.getPort();
    }

    @Override
    public int getSocketOption(byte aOption) throws IllegalArgumentException, IOException {
        switch (aOption) {
            case 0: {
                return this.socket.getTcpNoDelay() ? 1 : 0;
            }
            case 1: {
                return this.socket.getSoLinger();
            }
            case 2: {
                return this.socket.getKeepAlive() ? 1 : 0;
            }
            case 3: {
                return this.socket.getReceiveBufferSize();
            }
            case 4: {
                return this.socket.getSendBufferSize();
            }
        }
        throw new IllegalArgumentException("Illegal option: " + aOption + "!");
    }

    @Override
    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    @Override
    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setSocketOption(byte aOption, int aValue) throws IllegalArgumentException, IOException {
        switch (aOption) {
            case 0: {
                this.socket.setTcpNoDelay(aValue != 0);
                break;
            }
            case 1: {
                this.socket.setSoLinger(aValue != 0, aValue);
                break;
            }
            case 2: {
                this.socket.setKeepAlive(aValue != 0);
                break;
            }
            case 3: {
                this.socket.setReceiveBufferSize(aValue);
                break;
            }
            case 4: {
                this.socket.setSendBufferSize(aValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal option: " + aOption + "!");
            }
        }
    }
}

