/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import nl.lxtreme.ols.util.HostUtils;

public final class ThreadViolationDetectionRepaintManager
extends RepaintManager {
    private final boolean completeCheck;
    private WeakReference<JComponent> lastComponent;

    public ThreadViolationDetectionRepaintManager() {
        this(true);
    }

    public ThreadViolationDetectionRepaintManager(boolean aCompleteCheck) {
        this.completeCheck = aCompleteCheck;
    }

    public static ThreadViolationDetectionRepaintManager install() {
        Object m = ThreadViolationDetectionRepaintManager.currentRepaintManager();
        if (m instanceof ThreadViolationDetectionRepaintManager) {
            return (ThreadViolationDetectionRepaintManager)m;
        }
        return ThreadViolationDetectionRepaintManager.installNew();
    }

    private static Object currentRepaintManager() {
        try {
            Method method = SwingUtilities.class.getMethod("appContextGet", Object.class);
            method.setAccessible(true);
            return method.invoke(null, RepaintManager.class);
        }
        catch (Exception exception) {
            HostUtils.handleInterruptedException(exception);
            return null;
        }
    }

    private static ThreadViolationDetectionRepaintManager installNew() {
        ThreadViolationDetectionRepaintManager manager = new ThreadViolationDetectionRepaintManager();
        System.err.println("Installing custom repaint manager...");
        ThreadViolationDetectionRepaintManager.setCurrentManager(manager);
        return manager;
    }

    @Override
    public void addDirtyRegion(JComponent aComponent, int aX, int aY, int aWidth, int aHeight) {
        this.checkThreadViolations(aComponent);
        super.addDirtyRegion(aComponent, aX, aY, aWidth, aHeight);
    }

    @Override
    public synchronized void addInvalidComponent(JComponent aComponent) {
        this.checkThreadViolations(aComponent);
        super.addInvalidComponent(aComponent);
    }

    private void checkThreadViolations(JComponent aComponent) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || aComponent.isShowing())) {
            StackTraceElement[] stackTrace;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean imageUpdate = false;
            for (StackTraceElement st : stackTrace = Thread.currentThread().getStackTrace()) {
                String className = st.getClassName();
                if (repaint && className.startsWith("javax.swing.") && !className.startsWith("javax.swing.SwingWorker")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.lastComponent != null && aComponent == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(aComponent);
            System.err.println("\nEDT violation detected!\n");
            System.err.println("Component: " + aComponent);
            System.err.println("Trace:");
            for (StackTraceElement stackTraceElement : stackTrace) {
                System.err.println("\t" + stackTraceElement.toString());
            }
        }
    }
}

