/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.lxtreme.ols.util.ExportUtils;
import nl.lxtreme.ols.util.export.AttributeImpl;
import nl.lxtreme.ols.util.export.NullMacroResolver;
import nl.lxtreme.ols.util.export.TextElement;

public final class TagElement
implements ExportUtils.HtmlExporter.Element {
    private String name;
    private List<ExportUtils.HtmlExporter.Attribute> attributes;
    private List<ExportUtils.HtmlExporter.Element> children;
    private boolean needsCloseTag;

    public TagElement(String aName) {
        this(aName, true);
    }

    public TagElement(String aName, boolean aNeedsCloseTag) {
        this.name = aName;
        this.needsCloseTag = aNeedsCloseTag;
        this.attributes = new ArrayList<ExportUtils.HtmlExporter.Attribute>();
        this.children = new ArrayList<ExportUtils.HtmlExporter.Element>();
    }

    @Override
    public ExportUtils.HtmlExporter.Element addAttribute(String aName, String aValue) {
        AttributeImpl attr = new AttributeImpl(aName, aValue);
        this.attributes.add(attr);
        return this;
    }

    @Override
    public ExportUtils.HtmlExporter.Element addChild(ExportUtils.HtmlExporter.Element aChild) {
        if (!this.needsCloseTag) {
            throw new IllegalStateException("Cannot add children to tag that doesn't have close tag!");
        }
        ExportUtils.HtmlExporter.Element child = aChild.clone();
        this.children.add(child);
        return child;
    }

    @Override
    public ExportUtils.HtmlExporter.Element addChild(String aName) {
        if (!this.needsCloseTag) {
            throw new IllegalStateException("Cannot add children to tag that doesn't have close tag!");
        }
        TagElement child = new TagElement(aName);
        this.children.add(child);
        return child;
    }

    @Override
    public ExportUtils.HtmlExporter.Element addContent(String ... aValue) {
        if (!this.needsCloseTag) {
            throw new IllegalStateException("Cannot set contents for tag that doesn't have close tag!");
        }
        for (String value : aValue) {
            TextElement element = new TextElement(value);
            element.setParent(this);
            this.children.add(element);
        }
        return this;
    }

    @Override
    public ExportUtils.HtmlExporter.Element clone() {
        try {
            TagElement clone = (TagElement)super.clone();
            clone.name = this.name;
            clone.needsCloseTag = this.needsCloseTag;
            clone.attributes = new ArrayList<ExportUtils.HtmlExporter.Attribute>(this.attributes.size());
            for (ExportUtils.HtmlExporter.Attribute attr : this.getAttributes()) {
                clone.attributes.add(attr.clone());
            }
            clone.children = new ArrayList<ExportUtils.HtmlExporter.Element>(this.children.size());
            for (ExportUtils.HtmlExporter.Element child : this.getChildren()) {
                ExportUtils.HtmlExporter.Element childClone = child.clone();
                if (childClone instanceof TextElement) {
                    ((TextElement)childClone).setParent(clone);
                }
                clone.children.add(childClone);
            }
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Collection<ExportUtils.HtmlExporter.Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public ExportUtils.HtmlExporter.Element getChildByName(String aName) {
        for (ExportUtils.HtmlExporter.Element child : this.children) {
            if (!aName.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        return null;
    }

    @Override
    public Collection<ExportUtils.HtmlExporter.Element> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(new NullMacroResolver());
    }

    @Override
    public String toString(ExportUtils.HtmlExporter.MacroResolver aResolver) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(this.name);
        if (!this.attributes.isEmpty()) {
            for (i = 0; i < this.attributes.size(); ++i) {
                ExportUtils.HtmlExporter.Attribute attribute = this.attributes.get(i);
                sb.append(' ');
                sb.append(attribute.toString(aResolver));
            }
        }
        sb.append('>');
        if (this.needsCloseTag) {
            for (i = 0; i < this.children.size(); ++i) {
                ExportUtils.HtmlExporter.Element child = this.children.get(i);
                sb.append(child.toString(aResolver));
            }
            sb.append("</").append(this.name).append('>');
        }
        return sb.toString();
    }
}

