/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import nl.lxtreme.ols.util.export.CsvExporterImpl;
import nl.lxtreme.ols.util.export.HtmlExporterImpl;
import nl.lxtreme.ols.util.export.HtmlFileExporterImpl;
import nl.lxtreme.ols.util.export.TagElement;

public final class ExportUtils {
    private ExportUtils() {
    }

    public static CsvExporter createCsvExporter(File aFile) throws IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File cannot be null!");
        }
        return new CsvExporterImpl(aFile);
    }

    public static HtmlExporter createHtmlExporter() {
        return new HtmlExporterImpl(true);
    }

    public static HtmlFileExporter createHtmlExporter(File aFile) throws IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File cannot be null!");
        }
        return new HtmlFileExporterImpl(aFile);
    }

    public static interface HtmlFileExporter
    extends HtmlExporter {
        public void write(HtmlExporter.MacroResolver var1) throws IOException;

        public void close() throws IOException;
    }

    public static interface HtmlExporter {
        public static final Element META = new TagElement("meta", false);
        public static final Element H1 = new TagElement("h1");
        public static final Element H2 = new TagElement("h2");
        public static final Element H3 = new TagElement("h3");
        public static final Element P = new TagElement("p");
        public static final Element DIV = new TagElement("div");
        public static final Element SPAN = new TagElement("span");
        public static final Element TABLE = new TagElement("table");
        public static final Element TBODY = new TagElement("tbody");
        public static final Element THEAD = new TagElement("thead");
        public static final Element TFOOT = new TagElement("tfoot");
        public static final Element TR = new TagElement("tr");
        public static final Element TH = new TagElement("th");
        public static final Element TD = new TagElement("td");
        public static final Element BR = new TagElement("br", false);
        public static final Element HR = new TagElement("hr", false);

        public void addCssStyle(String var1);

        public Element getBody();

        public Element getHead();

        public void setTitle(String var1);

        public String toString(MacroResolver var1);

        public static interface MacroResolver {
            public Object resolve(String var1, Element var2);
        }

        public static interface Element
        extends Cloneable {
            public Element addAttribute(String var1, String var2);

            public Element addChild(Element var1);

            public Element addChild(String var1);

            public Element addContent(String ... var1);

            public Element clone();

            public Collection<Attribute> getAttributes();

            public Element getChildByName(String var1);

            public Collection<Element> getChildren();

            public String getName();

            public String toString(MacroResolver var1);
        }

        public static interface Attribute
        extends Cloneable {
            public Attribute clone();

            public String getName();

            public String getValue();

            public String toString(MacroResolver var1);
        }
    }

    public static interface CsvExporter {
        public void addRow(Object ... var1) throws IOException;

        public void close() throws IOException;

        public void setHeaders(String ... var1) throws IOException;
    }
}

