/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.dmx512;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.api.util.UnitOfTime;
import nl.lxtreme.ols.tool.base.BaseToolDialog;
import nl.lxtreme.ols.tool.base.ExportAware;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.tool.dmx512.DMX512Analyzer;
import nl.lxtreme.ols.tool.dmx512.DMX512AnalyzerTask;
import nl.lxtreme.ols.tool.dmx512.DMX512Data;
import nl.lxtreme.ols.tool.dmx512.DMX512DataSet;
import nl.lxtreme.ols.util.ExportUtils;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.StringUtils;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import org.osgi.framework.BundleContext;

public final class DMX512AnalyzerDialog
extends BaseToolDialog<DMX512DataSet>
implements ExportAware<DMX512DataSet> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(DMX512AnalyzerDialog.class.getName());
    private JComboBox dataLine;
    private JEditorPane outText;
    private ToolUtils.RestorableAction runAnalysisAction;
    private Action closeAction;
    private Action exportAction;

    public DMX512AnalyzerDialog(Window aOwner, ToolContext aToolContext, BundleContext aContext, DMX512Analyzer aTool) {
        super(aOwner, aToolContext, aContext, (Tool)aTool);
        this.initDialog();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void exportToFile(File aOutputFile, ExportAware.ExportFormat aFormat) throws IOException {
        if (ExportAware.ExportFormat.HTML.equals((Object)aFormat)) {
            this.storeToHtmlFile(aOutputFile, (DMX512DataSet)((Object)this.getLastResult()));
        } else if (ExportAware.ExportFormat.CSV.equals((Object)aFormat)) {
            this.storeToCsvFile(aOutputFile, (DMX512DataSet)((Object)this.getLastResult()));
        }
    }

    public void readPreferences(UserSettings aSettings) {
        this.setComboBoxIndex(this.dataLine, aSettings, "dataLine");
    }

    public void reset() {
        this.outText.setText(this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        this.runAnalysisAction.restore();
        this.setControlsEnabled(true);
        this.exportAction.setEnabled(false);
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("dataLine", this.dataLine.getSelectedIndex());
    }

    protected void onToolEnded(DMX512DataSet aAnalysisResult) {
        block2: {
            try {
                String htmlPage = aAnalysisResult != null ? this.toHtmlPage(null, aAnalysisResult) : this.getEmptyHtmlPage();
                this.outText.setText(htmlPage);
                this.outText.setEditable(false);
                this.runAnalysisAction.restore();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                throw new RuntimeException(exception);
            }
        }
    }

    protected void onToolStarted() {
    }

    protected void prepareToolTask(ToolTask<DMX512DataSet> aToolTask) {
        DMX512AnalyzerTask toolTask = (DMX512AnalyzerTask)aToolTask;
        toolTask.setDataLine(this.dataLine.getSelectedIndex() - 1);
    }

    protected void setControlsEnabled(boolean aEnable) {
        this.dataLine.setEnabled(aEnable);
        this.closeAction.setEnabled(aEnable);
        this.exportAction.setEnabled(aEnable);
    }

    private ExportUtils.HtmlExporter createHtmlTemplate(ExportUtils.HtmlExporter aExporter) {
        aExporter.addCssStyle("body { font-family: sans-serif; } ");
        aExporter.addCssStyle("table { border-width: 1px; border-spacing: 0px; border-color: gray; border-collapse: collapse; border-style: solid; margin-bottom: 15px; } ");
        aExporter.addCssStyle("table th { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; background-color: #C0C0FF; text-align: left; font-weight: bold; font-family: sans-serif; } ");
        aExporter.addCssStyle("table td { border-width: 1px; padding: 2px; border-style: solid; border-color: gray; font-family: monospace; } ");
        aExporter.addCssStyle(".error { color: red; } ");
        aExporter.addCssStyle(".warning { color: orange; } ");
        aExporter.addCssStyle(".date { text-align: right; font-size: x-small; margin-bottom: 15px; } ");
        aExporter.addCssStyle(".w100 { width: 100%; } ");
        aExporter.addCssStyle(".w35 { width: 35%; } ");
        aExporter.addCssStyle(".w30 { width: 30%; } ");
        aExporter.addCssStyle(".w15 { width: 15%; } ");
        aExporter.addCssStyle(".w10 { width: 10%; } ");
        aExporter.addCssStyle(".w8 { width: 8%; } ");
        aExporter.addCssStyle(".w7 { width: 7%; } ");
        ExportUtils.HtmlExporter.Element body = aExporter.getBody();
        body.addChild(ExportUtils.HtmlExporter.H1).addContent(new String[]{"DMX512 Analysis results"});
        body.addChild(ExportUtils.HtmlExporter.HR);
        body.addChild(ExportUtils.HtmlExporter.DIV).addAttribute("class", "date").addContent(new String[]{"Generated: ", "{date-now}"});
        ExportUtils.HtmlExporter.Element table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        ExportUtils.HtmlExporter.Element tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("colspan", "2").addContent(new String[]{"Statistics"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Decoded bytes"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{decoded-bytes}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Detected bus errors"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{detected-bus-errors}"});
        tr = tbody.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("class", "w30").addContent(new String[]{"Number of slots"});
        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{"{slot-count}"});
        table = body.addChild(ExportUtils.HtmlExporter.TABLE).addAttribute("class", "w100");
        ExportUtils.HtmlExporter.Element thead = table.addChild(ExportUtils.HtmlExporter.THEAD);
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w30").addAttribute("colspan", "2");
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w35").addAttribute("colspan", "4").addContent(new String[]{"Data"});
        tr = thead.addChild(ExportUtils.HtmlExporter.TR);
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w15").addContent(new String[]{"Index"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w15").addContent(new String[]{"Time"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Hex"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w10").addContent(new String[]{"Bin"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w8").addContent(new String[]{"Dec"});
        tr.addChild(ExportUtils.HtmlExporter.TH).addAttribute("class", "w7").addContent(new String[]{"ASCII"});
        tbody = table.addChild(ExportUtils.HtmlExporter.TBODY);
        tbody.addContent(new String[]{"{decoded-data}"});
        return aExporter;
    }

    private JPanel createPreviewPane() {
        JPanel panTable = new JPanel(new GridLayout(1, 1, 0, 0));
        this.outText = new JEditorPane("text/html", this.getEmptyHtmlPage());
        this.outText.setEditable(false);
        panTable.add(new JScrollPane(this.outText));
        return panTable;
    }

    private JPanel createSettingsPane() {
        int channelCount = this.getData().getChannels();
        JPanel settings = new JPanel(new SpringLayout());
        SpringLayoutUtils.addSeparator((Container)settings, (String)"Settings");
        settings.add(SwingComponentUtils.createRightAlignedLabel((String)"Data line"));
        this.dataLine = SwingComponentUtils.createOptionalChannelSelector((int)channelCount);
        settings.add(this.dataLine);
        SpringLayoutUtils.makeEditorGrid((Container)settings, (int)10, (int)4);
        return settings;
    }

    private String getEmptyHtmlPage() {
        ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
        return exporter.toString(new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("decoded-bytes".equals(aMacro) || "detected-bus-errors".equals(aMacro) || "baudrate".equals(aMacro)) {
                    return "-";
                }
                if ("decoded-data".equals(aMacro)) {
                    return null;
                }
                return null;
            }
        });
    }

    private void initDialog() {
        this.setMinimumSize(new Dimension(640, 480));
        JPanel settingsPane = this.createSettingsPane();
        JPanel previewPane = this.createPreviewPane();
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)settingsPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 0, 2, 0), 0, 0));
        contentPane.add((Component)previewPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 2, 0), 0, 0));
        JButton runAnalysisButton = ToolUtils.createRunAnalysisButton((ToolDialog)this);
        this.runAnalysisAction = (ToolUtils.RestorableAction)runAnalysisButton.getAction();
        JButton exportButton = ToolUtils.createExportButton((ExportAware)this);
        this.exportAction = exportButton.getAction();
        this.exportAction.setEnabled(false);
        JButton closeButton = ToolUtils.createCloseButton();
        this.closeAction = closeButton.getAction();
        JComponent buttons = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{runAnalysisButton, exportButton, closeButton});
        SwingComponentUtils.setupDialogContentPane((JDialog)((Object)this), (Component)contentPane, (Component)buttons, (JButton)runAnalysisButton);
    }

    private void storeToCsvFile(File aFile, DMX512DataSet aDataSet) {
        block3: {
            try {
                ExportUtils.CsvExporter exporter = ExportUtils.createCsvExporter((File)aFile);
                exporter.setHeaders(new String[]{"index", "start-time", "end-time", "event?", "event-type", "RxD event", "TxD event", "RxD data", "TxD data"});
                List decodedData = aDataSet.getData();
                for (int i = 0; i < decodedData.size(); ++i) {
                    DMX512Data ds = (DMX512Data)((Object)decodedData.get(i));
                    String startTime = UnitOfTime.format((double)aDataSet.getTime(ds.getStartSampleIndex()));
                    String endTime = UnitOfTime.format((double)aDataSet.getTime(ds.getEndSampleIndex()));
                    String eventType = ds.getEventName();
                    String dataValue = Integer.toString(ds.getData());
                    exporter.addRow(new Object[]{i, startTime, endTime, eventType, dataValue});
                }
                exporter.close();
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block3;
                LOG.log(Level.WARNING, "CSV export failed!", exception);
            }
        }
    }

    private void storeToHtmlFile(File aFile, DMX512DataSet aDataSet) {
        block2: {
            try {
                this.toHtmlPage(aFile, aDataSet);
            }
            catch (IOException exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                LOG.log(Level.WARNING, "HTML export failed!", exception);
            }
        }
    }

    private String toHtmlPage(File aFile, final DMX512DataSet aDataSet) throws IOException {
        int bitCount = 8;
        boolean bitAdder = false;
        ExportUtils.HtmlExporter.MacroResolver macroResolver = new ExportUtils.HtmlExporter.MacroResolver(){

            public Object resolve(String aMacro, ExportUtils.HtmlExporter.Element aParent) {
                if ("date-now".equals(aMacro)) {
                    DateFormat df = DateFormat.getDateInstance(1);
                    return df.format(new Date());
                }
                if ("decoded-bytes".equals(aMacro)) {
                    return aDataSet.getDecodedSymbols();
                }
                if ("slot-count".equals(aMacro)) {
                    return aDataSet.getSlotCount();
                }
                if ("detected-bus-errors".equals(aMacro)) {
                    return aDataSet.getDetectedErrors();
                }
                if ("decoded-data".equals(aMacro)) {
                    List decodedData = aDataSet.getData();
                    for (int i = 0; i < decodedData.size(); ++i) {
                        String bgColor;
                        DMX512Data ds = (DMX512Data)((Object)decodedData.get(i));
                        String eventName = ds.getEventName();
                        if ("FRAME".equals(eventName)) {
                            eventName = "Frame error";
                            bgColor = "#ff6600";
                        } else if ("PARITY".equals(eventName)) {
                            eventName = "Parity error";
                            bgColor = "#ff9900";
                        } else if ("START".equals(eventName)) {
                            eventName = "Start error";
                            bgColor = "#ffcc00";
                        } else {
                            bgColor = i % 2 == 0 ? "#ffffff" : "#eeeeee";
                        }
                        ExportUtils.HtmlExporter.Element tr = aParent.addChild(ExportUtils.HtmlExporter.TR).addAttribute("style", "background-color: " + bgColor + ";");
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{String.valueOf(i)});
                        tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{UnitOfTime.format((double)aDataSet.getTime(ds.getStartSampleIndex()))});
                        if (eventName == null) {
                            int data = ds.getData();
                            String dataHex = "0x" + StringUtils.integerToHexString((int)data, (int)2);
                            String dataBin = "0b" + StringUtils.integerToBinString((int)data, (int)8);
                            String dataDec = String.valueOf(data);
                            String dataASCII = "";
                            if (this.isPrintableCharacter(data)) {
                                dataASCII = String.valueOf((char)data);
                            }
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{dataHex});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{dataBin});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{dataDec});
                            tr.addChild(ExportUtils.HtmlExporter.TD).addContent(new String[]{dataASCII});
                            continue;
                        }
                        tr.addChild(ExportUtils.HtmlExporter.TD).addAttribute("colspan", "4").addContent(new String[]{eventName});
                    }
                }
                return null;
            }

            private boolean isPrintableCharacter(int aValue) {
                boolean withinRange = aValue >= 32 && aValue < 255;
                return withinRange;
            }
        };
        if (aFile == null) {
            ExportUtils.HtmlExporter exporter = this.createHtmlTemplate(ExportUtils.createHtmlExporter());
            return exporter.toString(macroResolver);
        }
        ExportUtils.HtmlFileExporter exporter = (ExportUtils.HtmlFileExporter)this.createHtmlTemplate((ExportUtils.HtmlExporter)ExportUtils.createHtmlExporter((File)aFile));
        exporter.write(macroResolver);
        exporter.close();
        return null;
    }
}

