// LISTING 25.5. Pobranie wartości atrybutu typu object

import com.atlassian.jira.component.ComponentAccessor;
import com.onresolve.scriptrunner.runner.customisers.WithPlugin;
@WithPlugin("com.riadalabs.jira.plugins.insight")

// 1. Pobranie komponentu ObjectFacade.
Class objectFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade");
def objectFacade = ComponentAccessor.getOSGiComponentInstanceOfType(objectFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade;

// 2. Pobranie zgłoszenia z uzupełnionym custom fieldem.
def issue = ComponentAccessor.getIssueManager().getIssueObject("CM-1");

// 3. Pobranie obiektu typu interfejsowego CustomField i wartości ze zgłoszenia.
def operatorsField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10402L);
def operatorsFieldValue = issue.getCustomFieldValue(operatorsField);

// 4. Pobranie wartości atrybutu z obiektu ObjectBean będącego atrybutem typu object.
String result = "";
operatorsFieldValue.each {
    objectBean ->

        // 4.1. Pobranie identyfikatora obiektu, którego referencja znajduje się w atrybucie.
        // Identyfikator atrybutu Branches to 20.
        def referencedObjectId = objectBean.getObjectAttributeBeans().find() {it.getObjectTypeAttributeId()==20}.getObjectAttributeValueBeans().get(0).getValue();

        // 4.2. Pobranie obiektu, którego identyfikator znajduje się w atrybucie typu object i zwrócenie wartości jego atrybutu Address.
        // Identyfikator atrybutu Address to 27.
        result += objectBean.getName() + ": " + objectFacade.loadObjectBean(referencedObjectId as int).getObjectAttributeBeans().find() {
        objectAttributeBean ->
            objectAttributeBean.getObjectTypeAttributeId()==27
        }.getObjectAttributeValueBeans().get(0).getTextValue() + " | ";
};

// 5. Wyświetlenie wyników.
// Jennifer Evans: ul. Długa i szeroka 2/3, 00-001 Warszawa | Ryan Lee: ul. Długa i szeroka 2/3,
// 00-001 Warszawa |
return result;