// LISTING 22.5. Aktualizacja wybranej strony w Confluence

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import groovy.json.JsonBuilder;
import groovy.json.JsonSlurper;

// 1. Inicjalizacja ApplicationLink.
def ApplicationLink getPrimaryConfluenceLink() {
    def applicationLinkService = ComponentLocator.getComponent(ApplicationLinkService);
    final ApplicationLink confluenceApplicationLink = applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType);
    return confluenceApplicationLink;
}

// 2. Inicjalizacja fabryczki do wysyłania żądań przez Confluence API.
def confluenceLink = getPrimaryConfluenceLink();
def authenticatedRequestFactory = confluenceLink.createImpersonatingAuthenticatedRequestFactory();

// 3. Inicjalizacja mapy podstawowych parametrów do aktualizacji strony głównej.
def updateHomePageRequestBody = [
    version: [
        // Oznaczenie kolejnej wersji strony jest obowiązkowe.
        number: "2"
    ],
    title: "My new title 1",
    type: "page",
    body: [
        storage: [
            value: "<p>New page data.</p>",
            representation: "storage"
        ]
    ]
];

// 4. Wykonanie aktualizacji wybranej strony Confluence.
// W adresie endpointa należy wskazać identyfikator zmienianej strony, np. 1266453.
String updatedPageId;
authenticatedRequestFactory
    .createRequest(Request.MethodType.PUT, "/rest/api/content/1266453")
    .addHeader("Content-Type", "application/json")
    .setRequestBody(new JsonBuilder(updateHomePageRequestBody).toString())
    .execute(new ResponseHandler<Response>() {

        @Override
        void handle(Response response) throws ResponseException {
            if (response.statusCode != HttpURLConnection.HTTP_OK) {
                throw new Exception(response.getResponseBodyAsString());
            } else {
                updatedPageId = new JsonSlurper().parseText(response.responseBodyAsString)["id"];
                log.info "Page ${updatedPageId} has been updated.";
            }
    }
});