<!-- LISTING 21.5. Połączenie z Jira REST API przy użyciu PHP -->

<?php

// 1. Parametry dostępu do Jira REST API, w tym token użytkownika Jiry.
define("JIRA_URL", "http://172.16.117.141:8080/rest/api/2/");
define("USERNAME", "user");
define("PASSWORD", "password");
define("TOKEN", "Njc0Nzk2OTA4MjM2OuvyeXGbojaXXYjCwAevamC8oDKO");

// 2. Funkcja do komunikacji z Jira REST API.
function get_from($request) {
    $curl = curl_init();
    curl_setopt_array($curl, array(
            CURLOPT_URL => JIRA_URL . "" . $request, 
            
            // 2.1. (Opcja 1) Uwierzytelnianie za pomocą nazwy użytkownika i hasła.
            CURLOPT_USERPWD => USERNAME . ":" . PASSWORD,
            CURLOPT_HTTPHEADER => array("Content-type: application/json"),

            // 2.2. (Opcja 2) Uwierzytelnianie za pomocą tokena użytkownika Jiry.
            CURLOPT_HTTPHEADER => array('Authorization: Bearer ' . TOKEN),
            CURLOPT_RETURNTRANSFER => true
        )
    );
    
    // 2.3. Wywołanie i zamknięcie połączenia.
    $result = curl_exec($curl);
    curl_close($curl);
    
    // 2.4. Konwersja danych JSON na PHP array.
    return json_decode($result);
}
?>

<!-- 3. Strona HTML-a.-->
<!DOCTYPE html>
<html>
<head>
    <title>Page Title</title>
    <script src="https://code.jquery.com/jquery-2.2.4.min.js"></script>
    <style>
        table, th, td {
            border: 1px solid;
            border-collapse: collapse;
        }
    </style>
</head>

<!-- 3.1. Ciało strony. -->
<body>
    <h1>Jira issues</h1>
    
    <!-- 3.2. Tabela z nagłówkami do wyświetlenia wyników. -->
    <table>
        <tr class="header">
            <th>Issue key</th>
            <th>Summary</th>
            <th>Assignee</th>
            <th>Status</th>
        </tr>
        <?php
        
        // 3.3. Wstawienie wierszy dla kolejnych zgłoszeń Jiry w pętli.
        
        // Pobranie węzła issues.
        $result = get_from("search?jql=project=test")->issues;
        
        // Uruchomienie pętli tworzącej wiersze.
        foreach ($result as $issue) {
            echo "<tr>";
            echo "<td>" . $issue->key . "</td>";
            echo "<td>" . $issue->fields->summary . "</td>";
            echo "<td>" . $issue->fields->assignee->name . "</td>";
            echo "<td>" . $issue->fields->status->name . "</td>";
            echo "</tr>";
        }
        ?>
    </table>
</body>
</html>