// LISTING 21.2. Aplikacja Javy wywołująca połączenie z Jira REST API
package org.example;

import org.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.stream.Collectors;

public class JiraExampleApi {
    public static void main(String[] args) {

        // 1. Token użytkownika.
        String token = "OTUxODQxMjc3ODIwOs8GGxW31/mPWMI9gH0UqLp+OQRq";

        // 2. URI endpointa Jira REST API.
        String urlString = "http://172.16.117.141:8080/rest/api/2/search?jql=project=test%20and%20created%20%3E=%202022-07-14%20and%20created%20%3C=%202022-07-16";
        // 3. Inicjalizacja zmiennej do przechowywania odpowiedzi z Jira REST API.
        
        String jsonString = "";
        try {

            // 4. Otwarcie połączenia z endpointem.
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();

            // 5. Dodanie parametrów połączenia.
            connection.addRequestProperty("Authorization", "Bearer " + token);
            connection.addRequestProperty("X-Atlassian-Token", "no-check");
            connection.addRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("GET");
            connection.setReadTimeout(5000);

            // 6. Nawiązanie połączenia.
            connection.connect();

            // 7. Przekształcenie ciała odpowiedzi do typu String.
            jsonString = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));

            // 8. Zakończenie połączenia.
            connection.disconnect();
        } catch (IOException ex) {

            // 9. Wyświetlenie w ekranie konsoli ewentualnych błędów.
            System.out.println(ex.getMessage());
        }

        // 10. Parsowanie odpowiedzi zapytania z typu String do obiektu JSON.
        JSONObject jsonObject = new JSONObject(jsonString);

        // 11. Wyświetlenie tekstowej reprezentacji obiektu JSON.
        System.out.println(jsonObject.toString());
    }
}