// LISTING 20.3. Zwrócenie danych w postaci obiektu JSON

import com.atlassian.jira.component.ComponentAccessor;
import com.onresolve.scriptrunner.runner.rest.common.CustomEndpointDelegate;
import groovy.json.JsonBuilder;
import groovy.transform.BaseScript;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
@BaseScript CustomEndpointDelegate delegate

// 1. Metoda GET.
// Wykonanie ograniczone do członków grupy jira-administrators.
getIssueByProject(httpMethod: "GET", groups: ["jira-administrators"]) {
    MultivaluedMap queryParams, String body ->
    
        // 1.1. Pobranie komponentu IssueManager.
        def issueManager = ComponentAccessor.getIssueManager();

        // 1.2. Utworzenie mapy danych ze zgłoszeń pochodzących z projektu, którego klucz został przekazany w parametrze GET.
        String projectKey = queryParams.getFirst("projectKey") as String;
        Long projectId = ComponentAccessor.getProjectManager().getProjectObjByKey(projectKey).getId();
        def issues = issueManager.getIssueObjects(issueManager.getIssueIdsForProject(projectId)).collect() {
            issue ->
                [
                    "issueKey": issue.getKey(),
                    "summary": issue.getSummary(),
                    "created": issue.getCreated(),
                    "assignee":issue.getAssignee()?.getName()
                ]
        };

        // 2. Zwrócenie wyniku.
        return Response.ok(new JsonBuilder(["items":issues]).toString()).build();
}