// LISTING 20.2. Strona oparta na REST Endpoincie

import javax.ws.rs.core.MediaType;
import com.onresolve.scriptrunner.runner.rest.common.CustomEndpointDelegate;
import groovy.transform.BaseScript;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
@BaseScript CustomEndpointDelegate delegate

// 1. Metoda GET.
// Wykonanie ograniczone do członków grupy jira-administrators.
getSomething(httpMethod: "GET", groups: ["jira-administrators"]) {

    // 1.1. Obiekty przechowujące parametry przekazane w zapytaniu i ciało żądania.
    MultivaluedMap queryParams, String body ->

        // 1.2. Pobranie parametru GET o nazwie exampleParam przekazanego w adresie URL.
        def userName = queryParams.getFirst("userName");

        // 1.3. Inicjalizacja kodu HTML-a strony.
        Writer sw = new StringWriter();
        sw << """
            <!DOCTYPE html>
            <html>
                <body>
                    <h1>Hello ${userName}</h1>
                    <p>My first paragraph.</p>
                </body>
            </html>
        """;

        // 2. Zwrócenie wyniku.
        return Response.ok().type(MediaType.TEXT_HTML).entity(sw.toString()).build();
}