// LISTING 20.1. Szkielet REST Endpointu w ScriptRunnerze

import javax.servlet.http.HttpServletRequest;
import com.onresolve.scriptrunner.runner.rest.common.CustomEndpointDelegate;
import groovy.transform.BaseScript;
import javax.ws.rs.core.MultivaluedMap
import javax.ws.rs.core.Response
@BaseScript CustomEndpointDelegate delegate

// 1. Metoda GET.
// Wykonanie ograniczone do członków grupy jira-administrators.
getSomething(httpMethod: "GET", groups: ["jira-administrators"]) {

    // 1.1. Obiekty przechowujące parametry przekazane w zapytaniu i ciało żądania.
    MultivaluedMap queryParams, String body ->
    
        // 1.2. Pobranie parametru GET o nazwie exampleParam przekazanego w adresie URL.
        String result = "GET request has been made. Request param = " + queryParams.getFirst("exampleParam");
    
        // 1.3. Zwrócenie wyniku.
        return Response.ok(result).build();
}

// 2. Metoda POST.
// Wykonanie ograniczone do członków grupy jira-administrators.
postSomething(httpMethod: "POST", groups: ["jira-administrators"]) {
    
    // 2.1. Obiekty przechowujące parametry przekazane w zapytaniu i ciało żądania.
    MultivaluedMap queryParams, String body, HttpServletRequest request ->
    
    // 2.2. Pobranie parametru POST o nazwie exampleParam przekazanego w ciele zapytania.
    String result = "Post request has been made. Request param " + queryParams.getFirst("exampleParam");
    
    // 2.3. Zwrócenie wyniku.
    return Response.ok(result).build();
}