// LISTING 17.4. Ustawienie wartości date picker i date time picker za pomocą behaviours

import com.atlassian.jira.issue.fields.CustomField;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.config.properties.APKeys;
import com.atlassian.jira.datetime.DateTimeFormatter;

// 1. Pobranie obiektów typu FieldForm pól formularza.
def startDateFieldForm = getFieldById("customfield_10600");
def endDateFieldForm = getFieldById("customfield_10703");

// 2. Pobranie obiektów typu interfejsowego Custom Field.
def startDateField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10600L) as CustomField;
def endDateField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10703L);

// 3. Wstawienie wartości dla pola typu date picker.
def dateNow = new Date().toTimestamp();
startDateFieldForm.setFormValue(
    // 2.1. Wywołanie funkcji zwracającej datę w formacie zalogowanego użytkownika.
    dateFormatterForUser(dateNow, startDateField)
);

// 3. Wstawienie wartości dla pola typu date time picker.
def futureDateTimeString ="2022-08-22 22:31";
def futureDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse("2022-08-22 23:11").toTimestamp();
endDateFieldForm.setFormValue(
    // 3.1. Wywołanie funkcji zwracającej datę w formacie zalogowanego użytkownika.
    dateFormatterForUser(futureDateTime, endDateField)
);

// 4. Funkcja zwracająca datę i czas w formacie użytkownika.
static String dateFormatterForUser(Timestamp inputDate, CustomField sourceField) {

    // 4.1. Pobranie klucza property do ustawień czasu w Jirze.
    def dateFormatProperty = (sourceField.customFieldType instanceof DateTimeCFType) ?
    APKeys.JIRA_DATE_TIME_PICKER_JAVA_FORMAT : APKeys.JIRA_DATE_PICKER_JAVA_FORMAT;

    // 4.2. Pobranie property z ustawień daty i czasu w Jirze.
    def requiredDateFormat = ComponentAccessor.getApplicationProperties().getDefaultBackedString(dateFormatProperty);

    // 4.3. Pobranie formattera daty i czasu dla danego użytkownika.
    def user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
    def jiraFormatter = ComponentAccessor.getComponent(DateTimeFormatter).forUser(user);

    // 4.4. Inicjalizacja obiektu formattera.
    def formatterForFieldType = new SimpleDateFormat(requiredDateFormat, jiraFormatter.locale);

    // 4.5. Zwrócenie daty/czasu w formacie zalogowanego użytkownika.
    return formatterForFieldType.format(inputDate);
}