// LISTING 16.6. Przejście z pominięciem walidatorów, warunków i uprawnień za pomocą WorkflowTransitionUtil

import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue zgłoszenia, na którym będzie wykonywane przejście.
def issue = ComponentAccessor.getIssueManager().getIssueObject("WT-2");

// 2. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika wykonującego przejście.
def adminUser = ComponentAccessor.getUserManager().getUserByName("kwascow");

// 3. Pobranie komponentu WorkflowTransitionUtil.
def workflowTransitionUtil = (WorkflowTransitionUtil) JiraUtils.loadComponent("com.atlassian.jira.workflow.WorkflowTransitionUtilImpl", WorkflowTransitionUtilImpl.class);

// 4. Wykluczenie warunków, walidatorów i weryfikacji uprawnień w trakcie wykonywania przejścia.
workflowTransitionUtil.addAdditionalInput("com.atlassian.jira.internal.workflow.skipConditions", true);
workflowTransitionUtil.addAdditionalInput("com.atlassian.jira.internal.workflow.skipValidators", true);
workflowTransitionUtil.addAdditionalInput("com.atlassian.jira.internal.workflow.skipPermissions", true);

// 5. Ustawienie zgłoszenia, na którym ma zostać wykonane przejście.
workflowTransitionUtil.setIssue(issue);

// 6. Ustawienie klucza użytkownika realizującego przejście.
workflowTransitionUtil.setUserkey(adminUser.getKey());

// 7. Ustawienie identyfikatora wykonywanego przejścia.
// Numer 61 oznacza przejście ze statusu In Progress do Done.
workflowTransitionUtil.setAction(61);

// 8. Utworzenie mapy parametrów z danymi zgłoszenia.
Map params = new HashMap();

// 8.1. Dodanie komentarza.
params.put("comment", "Sample comment");

// 8.2. Zmiana rozwiązania (resolution) i custom fieldu o identyfikatorze 10115.
// Uwaga! Opcja może nie działać w niektórych wersjach Jiry.
params.put("resolution", 10001);
params.put("10115", "Sample comment1");

// 8.3. Dodanie parametrów do konfiguracji przejścia.
workflowTransitionUtil.setParams(params);

// 9. Walidacja przejścia.
workflowTransitionUtil.validate();

// 10. Wykonanie przejścia.
workflowTransitionUtil.progress();