// LISTING 16.2. Wykonanie przejścia za pomocą WorkflowTransitionUtil 7

import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue zgłoszenia, na którym będzie wykonywane przejście.
def issue = ComponentAccessor.getIssueManager().getIssueObject("WT-1");

// 2. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika wykonującego przejście.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 3. Pobranie komponentu WorkflowTransitionUtil.
def workflowTransitionUtil = (WorkflowTransitionUtil) JiraUtils.loadComponent("com.atlassian.jira.workflow.WorkflowTransitionUtilImpl", WorkflowTransitionUtilImpl.class);

// 4. Ustawienie zgłoszenia, na którym ma zostać wykonane przejście.
workflowTransitionUtil.setIssue(issue);

// 5. Ustawienie klucza użytkownika realizującego przejście.
workflowTransitionUtil.setUserkey(adminUser.getKey());

// 6. Ustawienie identyfikatora wykonywanego przejścia.
// Numer 41 oznacza przejście ze statusu To Do do In Progress.
workflowTransitionUtil.setAction(41);

// 7. Walidacja przejścia.
workflowTransitionUtil.validate();

// 8. Wykonanie przejścia.
workflowTransitionUtil.progress();