// LISTING 15.5. Pobranie wersji ze zgłoszenia

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego Issue ze zdefiniowanymi wersjami.
def issue = ComponentAccessor.getIssueManager().getIssueObject("SKX-4");

// 2. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();

// 3. Pobranie danych o wersjach ze zgłoszenia za pomocą pętli each().
def result1 = "";
issue.getFixVersions().each {
    version ->
        result1 += "version | ";
        result1 += "versionName: " + version.getName() + ", ";
        result1 += "versionStartDate: " + version.getStartDate().getDateString() + ", ";
        result1 += "versionReleaseDate: " + version.getReleaseDate().getDateString();
        result1 += "<br />";
};

// 4. Pobranie danych o wersjach ze zgłoszenia za pomocą metody collect().
def result2 = issue.getFixVersions().collect() {
    version -> 
        "version | versionName: ${version.getName()}, versionStartDate: ${version.getStartDate().getDateString()}, versionReleaseDate: ${version.getReleaseDate().getDateString()}"
};
result2 = String.join("<br />", result2);

// 5. Wyświetlenie wyników.
/* version | versionName: Version 1, versionStartDate: 7/1/22, versionReleaseDate: 7/14/22
version | versionName: Version 2, versionStartDate: 7/15/22, versionReleaseDate: 7/21/22
version | versionName: Version 1, versionStartDate: 7/1/22, versionReleaseDate: 7/14/22
version | versionName: Version 2, versionStartDate: 7/15/22, versionReleaseDate: 7/21/22 */
return "${result1}${result2}";