// LISTING 15.3. Zmiana wartości komponentu

import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie menedżerów.
def projectComponentManager = ComponentAccessor.getProjectComponentManager();

// 2. Pobranie komponentu Moduł X o identyfikatorze 10005 i zrzutowanie go do obiektu typu interfejsowego MutableProjectComponent.
// Identyfikator został pobrany z adresu URL linku do edycji komponentu.
def editedComponent = projectComponentManager.getProjectComponent(10005) as MutableProjectComponent;

// 3. Ustawienie nowych wartości komponentu za pomocą setterów.
editedComponent.setName("Moduł X");
editedComponent.setArchived(true);
editedComponent.setAssigneeType(2L);
editedComponent.setLead(ComponentAccessor.getUserManager().getUserByName("jnowak").getKey());
editedComponent.setDescription("Modified description");

// 4. Wykonanie aktualizacji komponentu.
projectComponentManager.update(editedComponent);