// LISTING 15.13. Klonowanie projektu za pomocą klasy CopyProject z pluginu ScriptRunner

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.onresolve.scriptrunner.canned.jira.admin.CopyProject;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;

// 1. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika z uprawnieniami do tworzenia projektów.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 2. Pobranie menedżerów.
def projectManager = ComponentAccessor.getProjectManager();

// 3. Dane do klonowania projektu.

// Klucz projektu będącego szablonem do sklonowania.
def sourceProjectKey = "TBP";

// Klucz i nazwa nowego projektu. Uwaga! Obie wartości muszą być unikatowe.
def newProjectKey = "BP1";
def newProjectName = "Business project - Processing sth";

// 4. Uruchomienie procesu klonowania projektu.

// 4.1. Zdefiniowanie wątku wykonującego operację i opakowanie go komponentem JiraThreadLocalUtils.
Thread executorThread = new Thread(JiraThreadLocalUtils.wrap() {

    // 4.2. Utworzenie obiektu klasy kopiującej projekt.
    def copyProject = new CopyProject();

    // 4.3. Zdefiniowanie parametrów kopiowania, w tym klonowania wersji, komponentów, dashboardów, filtrów i zgłoszeń.
    def copyProjectSettings = [
    (CopyProject.FIELD_SOURCE_PROJECT) : sourceProjectKey,
    (CopyProject.FIELD_TARGET_PROJECT) : newProjectKey,
    (CopyProject.FIELD_TARGET_PROJECT_NAME) : newProjectName,
    (CopyProject.FIELD_COPY_VERSIONS) : true,
    (CopyProject.FIELD_COPY_COMPONENTS) : true,
    (CopyProject.FIELD_COPY_ISSUES) : true,
    (CopyProject.FIELD_COPY_DASH_AND_FILTERS) : true,
    ];

    // 4.4. Walidacja parametrów klonowania.
    def validateResult = copyProject.doValidate(copyProjectSettings, false);

    if(validateResult.hasAnyErrors()) {
        
        // 4.5. Zwrócenie logów błędów w przypadku niepoprawnej walidacji.
        log.warn("Couldn't create project: $validateResult");
    } else {
        
        // 4.6. Przelogowanie na użytkownika z grupy jira-administrators.
        ComponentAccessor.getJiraAuthenticationContext().setLoggedInUser(adminUser);
        
        // 4.7. Wykonanie klonowania projektu z zadanymi parametrami.
        copyProject.doScript(copyProjectSettings);
    }
});

// 4.8. Uruchomienie wątku.
executorThread.start();