// LISTING 13.3. Aktualizacja wybranych typów custom fieldów

import java.text.SimpleDateFormat;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika z prawami do wykonywania operacji w zgłoszeniach.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 2. Pobranie komponentu IssueManager.
def issueManager = ComponentAccessor.getIssueManager();

// 3. Pobranie obiektu typu interfejsowego Issue zgłoszenia do edycji i zrzutowanie go do MutableIssue.
def issue = ComponentAccessor.getIssueManager().getIssueObject("TP-1") as MutableIssue;

// 4. Pobranie obiektów typu interfejsowego CustomField, których wartość będzie zmieniana.
def textDataField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10200L);
def numberDataField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10201L);
def singleUserField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10208L);
def usersField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10209L);
def singleChoiceListField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10202L);
def multipleChoicesListField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10204L);
def dateField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10206L);
def dateTimeField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10212L);
def singleGroupField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10210L);
def groupsField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10211L);

// 5. Zmiana wartości custom fieldów w zgłoszeniu.

// 5.1. Text field (single line) i text field (multi-line).
issue.setCustomFieldValue(textDataField, "new text");

// 5.2. Number field.
Double numberToAdd = Double.parseDouble("123.67");
issue.setCustomFieldValue(numberDataField, numberToAdd);

// 5.3. Select list (single choice).

// Pobranie wszystkich dostępnych opcji z ustawień custom fieldu.
def availableOptions1 = ComponentAccessor.getOptionsManager().getOptions(singleChoiceListField.getRelevantConfig(issue));

// Wybranie opcji do ustawienia w custom fieldzie.
def optionToSelect = availableOptions1.find() {
    option ->
        option.getValue().equals("value3");
};

// Wstawienie wybranej opcji do custom fieldu w zgłoszeniu.
issue.setCustomFieldValue(singleChoiceListField, optionToSelect);

// 5.4. Select list (multiple choices).

// Pobranie wszystkich dostępnych opcji z ustawień custom fieldu.
def availableOptions2 = ComponentAccessor.getOptionsManager().getOptions(multipleChoicesListField.getRelevantConfig(issue));

// Wybranie opcji do ustawienia w custom fieldzie.
def optionsToSelect = availableOptions2.findAll() {
    option ->
        option.getValue().equals("value1") || option.getValue().equals("value2");
};

// Wstawienie wybranej opcji do custom fieldu w zgłoszeniu.
issue.setCustomFieldValue(multipleChoicesListField, optionsToSelect);

// 5.5. User picker (single user).
def userToAdd1 = ComponentAccessor.getUserManager().getUserByName("mkopernik");
issue.setCustomFieldValue(singleUserField, userToAdd1);

// 5.6. User picker (multiple users).

// Pobranie obiektów typu interfejsowego ApplicationUser wybranych użytkowników do dodania.
def userToAdd2 = ComponentAccessor.getUserManager().getUserByName("akowalski");
def userToAdd3 = ComponentAccessor.getUserManager().getUserByName("jnowak");

// Pobranie aktualnej zawartości user picker (multiple users) ze zgłoszenia.
def usersFieldValue = issue.getCustomFieldValue(usersField) as ArrayList<ApplicationUser>;

// Dodanie obiektów typu interfejsowego ApplicationUser nowych użytkowników do aktualnej listy.
usersFieldValue.add(userToAdd2);
usersFieldValue.add(userToAdd3);

// Dodanie zmodyfikowanej listy obiektów typu interfejsowego ApplicationUser użytkowników do custom fieldu w zgłoszeniu.
issue.setCustomFieldValue(usersField, usersFieldValue);

// 5.7. Date picker.

// Zdefiniowanie formattera do parsowania daty ze Stringu.
SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

// Parsowanie daty ze Stringu i rzutowanie do Timestamp.
def dateToAdd = formatter.parse("2022-06-01").toTimestamp();

// Przypisanie wartości do custom fieldu w zgłoszeniu.
issue.setCustomFieldValue(dateField, dateToAdd);

// 5.8. Date time picker.

// Zdefiniowanie formattera do parsowania daty ze Stringu.
SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd HH:mm");

// Parsowanie daty ze Stringu i rzutowanie do Timestamp.
def dateTimeToAdd = formatter2.parse("2022-06-01 23:11").toTimestamp();

// Przypisanie wartości custom fieldu w zgłoszeniu.
issue.setCustomFieldValue(dateTimeField, dateTimeToAdd);

// 5.9. Group picker (single group).
// Utworzenie jednoelementowej ArrayList z grupą do wstawienia w custom fieldzie.
def groupToAdd1 = ComponentAccessor.getGroupManager().getGroup("team1").collect();
issue.setCustomFieldValue(singleGroupField, groupToAdd1);

// 5.10. Group picker (multiple groups).

// Pobranie aktualnie zapisanych grup z group picker (multiple groups) w zgłoszeniu.
def currentGroups = issue.getCustomFieldValue(groupsField) as ArrayList;

// Zdefiniowanie obiektu ArrayList, jeżeli custom field w zgłoszeniu jest puste.
if (currentGroups==null) currentGroups = new ArrayList<>();

// Pobranie obiektów ImmutableGroup do dodania.
def groupToAdd2 = ComponentAccessor.getGroupManager().getGroup("team2");
def groupToAdd3 = ComponentAccessor.getGroupManager().getGroup("team3");

// Dodanie nowych grup do aktualnej listy pobranej z group picker (multiple groups) w zgłoszeniu.
def groupsToAdd = new ArrayList<>();
groupsToAdd.add(groupToAdd2);
groupsToAdd.add(groupToAdd3);
currentGroups.addAll(groupsToAdd);

// Usunięcie ewentualnych duplikatów.
currentGroups.unique();

// (Opcja 1) Dopisanie nowych grup do custom fieldu.
issue.setCustomFieldValue(groupsField, currentGroups);

// (Opcja 2) Nadpisanie obecnej wartości custom fieldu nową listą grup.
issue.setCustomFieldValue(groupsField, groupsToAdd);

// 6. Wykonanie zmian w zgłoszeniu.
issueManager.updateIssue(adminUser, issue, EventDispatchOption.ISSUE_UPDATED, false);