// LISTING 13.12. Przykład poprawnej walidacji i utworzenia zgłoszenia

import org.apache.commons.lang3.ArrayUtils;
import java.sql.Array;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueInputParameters;

// 1. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika wykonującego operację.

// (Opcja 1) Użytkownik nieposiadający uprawnień do tworzenia zgłoszeń w projekcie.
def permitedUser = ComponentAccessor.getUserManager().getUserByName("tuser1");

// 2. Przełączenie zalogowanego użytkownika na wskazanego w zmiennej permittedUser.
ComponentAccessor.getJiraAuthenticationContext().setLoggedInUser(permitedUser);

// 3. Pobranie obiektów typu interfejsowego CustomField, których wartości będą dodawane do nowo tworzonego zgłoszenia.
def someTextField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10300L);
def someNumberField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10301L);
def someListField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10302L);

// 4. Pobranie komponentów IssueService i IssueInputParameters.
def issueService = ComponentAccessor.getIssueService();
IssueInputParameters inputParameters = issueService.newIssueInputParameters();

// 5. Uzupełnienie parametrów za pomocą interfejsu IssueInputParameters.
// projectId == 10200 => Test project 2.
// issueTypeId == 10001 => Story.
inputParameters.setProjectId(10200)
    .setIssueTypeId("10001")
    // (Opcja 2) Brak Summary.
    .setSummary("Summary")
    .setReporterId(permitedUser.getName())
    .setAssigneeId(permitedUser.getName())
    // Dodanie poprawnych danych do custom fieldów.
    // (Opcja 3) Brak pola oznaczonego jako obowiązkowe.
    .addCustomFieldValue(someTextField.getIdAsLong(), ArrayUtils.toArray("some text") as String[])
    // (Opcja 4) Próba wstawienia wartości tekstowej do pola numerycznego.
    .addCustomFieldValue(someNumberField.getIdAsLong(), ArrayUtils.toArray("123") as String[])
    // (Opcja 5) Próba wstawienia niepoprawnych danych dla pola typu select list.
    .addCustomFieldValue(someListField.getIdAsLong(), ArrayUtils.toArray("10101", "value2") as String[]);

// 6. Walidacja parametrów zgłoszenia za pomocą użytkownika zdefiniowanego w zmiennej permittedUser.
def createValidationResult = issueService.validateCreate(permitedUser, inputParameters);

// (Opcja 6)
log.error("cause :" + createValidationResult.getErrorCollection().getErrors().toString())

// 7. Utworzenie zgłoszenia za pomocą użytkownika zdefiniowanego w zmiennej permittedUser.
// Metoda create zwraca obiekt IssueService.IssueResult.
def createIssueResult = issueService.create(permitedUser, createValidationResult);

// 8. Możliwość pobrania obiektu typu interfejsowego Issue nowo utworzonego zgłoszenia.
def issue = createIssueResult.getIssue();