// LISTING 12.3. Rzutowanie wartości pobranych z custom fieldów

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("TEST-1");

// 3. Pobranie obiektów implementujących CustomField przez identyfikator.
def environmentField = customFieldManager.getCustomFieldObject(10117L);
def envIdField = customFieldManager.getCustomFieldObject(10119L);
def envIdOldField = customFieldManager.getCustomFieldObject(10121L);

// 4. Pobranie wartości custom fieldu ze zgłoszenia.

// Rzutowanie do String w Groovym.
def environmentFieldValue1 = issue.getCustomFieldValue(environmentField) as String;

// Rzutowanie do String w składni Javy.
String environmentFieldValue2 = (String) issue.getCustomFieldValue(environmentField);

// Rzutowanie do Integer w Groovym.
def envIdFieldValue1 = issue.getCustomFieldValue(envIdField) as int;

// Rzutowanie do Double w Groovym.
def envIdFieldValue2 = issue.getCustomFieldValue(envIdField) as Double;

// Rzutowanie do Integer w składni Javy.
Integer envIdFieldValue3 = (Integer) issue.getCustomFieldValue(envIdField);

// Rzutowanie do Double w składni Javy — tylko w przypadku number fieldów.
Double envIdFieldValue4 = (Double) issue.getCustomFieldValue(envIdField);

// Rzutowanie ze String do Integer w Groovym.
def envIdOldFieldValue1 = issue.getCustomFieldValue(envIdOldField) as int;

// Rzutowanie ze String do Double w Groovym.
def envIdOldFieldValue2 = issue.getCustomFieldValue(envIdOldField) as Double;

// Rzutowanie ze String do Integer w składni Javy.
def envIdOldFieldValue3 = Integer.parseInt(issue.getCustomFieldValue(envIdOldField) as String);

// Rzutowanie ze String do Double w składni Javy.
Double envIdOldFieldValue4 = Double.parseDouble(issue.getCustomFieldValue(envIdOldField) as String);

// 5. Wyświetlenie wyników.
// environmentFieldValue1: Windows 11 | environmentFieldValue2: Windows 11 |
// envIdFieldValue1: 14356 | envIdFieldValue2: 14356.0 | envIdFieldValue3: 14356 |
// envIdFieldValue3: 14356.0 | envIdOldFieldValue1: 11234 | envIdOldFieldValue2: 11234.0 |
// envIdOldFieldValue3: 11234 | envIdOldFieldValue4: 11234.0
return "environmentFieldValue1: ${environmentFieldValue1} | environmentFieldValue2: ${environmentFieldValue2} | envIdFieldValue1: ${envIdFieldValue1} | envIdFieldValue2: ${envIdFieldValue2} | envIdFieldValue3: ${envIdFieldValue3} | envIdFieldValue3: ${envIdFieldValue4} | envIdOldFieldValue1: ${envIdOldFieldValue1} | envIdOldFieldValue2: ${envIdOldFieldValue2} | envIdOldFieldValue3: ${envIdOldFieldValue3} | envIdOldFieldValue4: ${envIdOldFieldValue4}";