// LISTING 12.16. Wyświetlenie w polu Additional info wartości określonej w wymaganiach biznesowych

import java.util.ArrayList;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.option.LazyLoadedOption;

// 1. Pobranie obiektu DelegatingApplicationUser z Assignee.
def assignee = issue.getAssignee();

// 2. Pobranie obiektu implementującego CustomField dla pola Task category.
def taskCategoryField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10601L);

// 3. Pobranie wartości pola Task category.
def taskCategoryFieldValue = issue.getCustomFieldValue(taskCategoryField) as ArrayList<LazyLoadedOption>;

// 4. Mapowanie opcji do wartości wskazanych w wymaganiach biznesowych.
Map mapOptions = [
"Utrzymanie":3,
"Nowe funkcjonalności (standard)":7,
"Nowe funkcjonalności (premium)":4,
"Zgłoszenie zarządu":-2,
"Zgłoszenie kierownika pionu":-1,
"Zgłoszenie pracownika operacyjnego":3
];

// 5. Wyszukanie najkrótszego czasu rozwiązania zgłoszenia.
// Wybranie zgłoszeń niezaczynających się od wyrażenia Zgłoszenie.
// Zmapowanie nazwy opcji na liczbę dni i przekonwertowanie wyniku na obiekt ArrayList<Integer>.
// Posortowanie rosnąco otrzymanej listy i pobranie pierwszej wartości == najmniejszej wartości.
int timeInDay = 0;
def timeInDayList = taskCategoryFieldValue.findAll() {
    option ->
        !option.getValue().matches("^Zgłoszenie.*\$")
    }.collect() {
        option ->
             mapOptions.getAt(option.getValue())
    }.sort() as ArrayList;
if (timeInDayList.isEmpty()) return null;
else timeInDay = timeInDayList.get(0);

// 6. Wyszukanie najmniejszej wartości modyfikującej czas wykonania zlecenia.
// Wybranie zgłoszeń zaczynających się od wyrażenia Zgłoszenie.
// Zmapowanie nazwy na wartość i przekonwertowanie wyniku na obiekt ArrayList<Integer>.
// Posortowanie rosnąco otrzymanej listy i pobranie pierwszej wartości == najmniejszej wartości.
int modifyTimeInDay = 0;
def modifyTimeInDayList = taskCategoryFieldValue.findAll() {
    option ->
        option.getValue().matches("^Zgłoszenie.*\$")
    }.collect() {
        option ->
            mapOptions.getAt(option.getValue())
    }.sort() as ArrayList;
if (modifyTimeInDayList.isEmpty()) return null;
else modifyTimeInDay = modifyTimeInDayList.get(0);

// 7. Pomniejszenie najniższej wartości czasu o najniższy modyfikator.
int timeToResolve = timeInDay + modifyTimeInDay;

// 8. Wygenerowanie treści Additional info dla pracownika i kontraktora.
// Warunek oparty na obecności w full name kontaktora sufiksu (kontraktor <nazwa firmy>).
String additionalInfoFieldValue = "";
if (assignee.getDisplayName().matches("^.*(\\(kontraktor.*\\))+\$")) {
    additionalInfoFieldValue = "Przed akceptacją zgłoszenia kontraktor zobowiązany jest załączyć skan podpisanego oświadczenia o akceptacji procedury realizacji zgłoszeń i deklaracji gwarantowanego ${timeToResolve}-dniowego SLA.";
} else {
    additionalInfoFieldValue = "Oczekiwany czas realizacji zgłoszenia to ${timeToResolve} dni.";
}
// 9. Zwrócenie wartości Additional info.
return additionalInfoFieldValue;