// LISTING 12.10. Badanie wartości custom fieldu typu select list (multiple choices)

import java.lang.Boolean;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.option.LazyLoadedOption;

// 1. Pobranie menedżerów.
def issueManager = ComponentAccessor.getIssueManager();
def customFieldManager = ComponentAccessor.getCustomFieldManager();

// 2. Pobranie przykładowego zgłoszenia według klucza.
def issue = issueManager.getIssueObject("ZDZ-1");

// 3. Pobranie obiektu implementującego CustomField.
def impactField = customFieldManager.getCustomFieldObject(10300L);

// 4. Pobranie listy wybranych opcji custom fieldu ze zgłoszenia i rzutowanie do listy obiektów LazyLoadedOption.
def impactFieldValues = issue.getCustomFieldValue(impactField) as ArrayList <LazyLoadedOption>;

// 5. Weryfikacja, czy opcja została zaznaczona — metoda find().
// Metoda zwraca jeden wynik lub wartość null.
Boolean result1 = impactFieldValues.find() {option -> option.getValue().equals("Systemy dostawców zewnętrznych")}!=null;
Boolean result2 = impactFieldValues.find() {option -> option.getOptionId()==10210}!=null;

// 6. Weryfikacja, czy została zaznaczona opcja Systemy dostawców zewnętrznych, metodą findAll().
// Metoda zwraca listę znalezionych wyników lub listę z zerową liczbą elementów.
Boolean result3 = !impactFieldValues.findAll() {option -> option.getValue().equals("Systemy dostawców zewnętrznych")}.isEmpty();
Boolean result4 = impactFieldValues.findAll() {option -> option.getOptionId()==10210}.size()>0;

// 7. Weryfikacja, czy została zaznaczona opcja Systemy dostawców zewnętrznych, metodą any().
// Metoda zwraca true albo false.
Boolean result5 = impactFieldValues.any() {option -> option.getValue().equals("Systemy dostawców zewnętrznych")};
Boolean result6 = impactFieldValues.any() {option -> option.getOptionId()==10210};

// 8. Weryfikacja, czy została zaznaczona opcja zawierająca zadany ciąg znaków.
// Metoda zwraca true albo false.
Boolean result7 = impactFieldValues.any() {option -> option.getValue().startsWith("System")}; // na początku
Boolean result8 = impactFieldValues.any() {option -> option.getValue().toLowerCase().matches(".*(dostawców).*")}; // w środku

// 9. Zwrócenie wyników.
// result1: true | result2: false | result3: true | result4: false | result5: true | result6: false |
// result7: true | result8: true
return "result1: ${result1} | result2: ${result2} | result3: ${result3} | result4: ${result4} | result5: ${result5} | result6: ${result6} | result7: ${result7} | result8: ${result8}";