// LISTING 3.8. Wstrzyknięcie i użycie komponentu IssueLinkManager

import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentu IssueLinkManager.
def issueLinkManager = ComponentAccessor.getIssueLinkManager();

// 2. Pobranie obiektów typu interfejsowego Issue przykładowych zgłoszeń zawierających linki.
def issue1 = ComponentAccessor.getIssueManager().getIssueObject("BP1-3");
def issue2 = ComponentAccessor.getIssueManager().getIssueObject("BP1-4");

// 3. Pobranie linków typu inward i outward ze zgłoszenia.
def inwardLinks = issueLinkManager.getInwardLinks(issue1.getId());
def outwardLinks = issueLinkManager.getInwardLinks(issue1.getId());

// 4. Utworzenie linku typu Related o identyfikatorze 10003 między issue1 i issue2.

// Pobranie obiektu typu interfejsowego ApplicationUser użytkownika z uprawnieniami do tworzenia linków w projekcie.
def user = ComponentAccessor.getUserManager().getUserByName("admin");

// Utworzenie linku.
issueLinkManager.createIssueLink(issue1.getId(), issue2.getId(), 10003L, 1, user);