// LISTING 3.18. Wstrzyknięcie i użycie komponentu VersionManager

import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentów.
def versionManager = ComponentAccessor.getVersionManager();
def projectManager = ComponentAccessor.getProjectManager();

// 2. Pobranie obiektów wszystkich istniejących wersji z różnych projektów.
def allVersions = versionManager.getAllVersions();

// 3. Pobranie obiektów wersji z wybranych projektów.
def project = projectManager.getProjectObj(10406L);
def projectList = [project];
def versions = versionManager.getAllVersionsForProjects(projectList, false);

// 4. Tworzenie i edycja wersji.
// Zob. przykłady w podrozdziale 15.2.3.

// 5. Wyświetlenie wyników.
// allVersions: Version 1.0, Version 2.0, Version 3.0, Version 1, Version 2, Version 3 fixed, Version1, Version2 | versions: Version1, Version2
return "allVersions: ${String.join(", ", allVersions.collect() {version -> version.getName()})} | versions: ${String.join(", ", versions.collect() {version -> version.getName()})}";