// LISTING 3.16. Wstrzyknięcie i użycie komponentu SubTaskManager

import com.atlassian.jira.component.ComponentAccessor;

// 1. Wstrzyknięcie komponentu SubTaskManager.
def subTaskManager = ComponentAccessor.getSubTaskManager();

// 2. Pobranie obiektu typu interfejsowego Issue przykładowego zgłoszenia z sub-taskami.
def issue = ComponentAccessor.getIssueManager().getIssueObject("BP1-3");

// 3. Pobranie listy sub-tasków ze zgłoszenia.
def subTasks = subTaskManager.getSubTaskObjects(issue);

// 4. Schemat tworzenia linku między utworzonym obiektem sub-tasku a taskiem nadrzędnym.
// Wymagane jest utworzenie obiektu typu interfejsowego Issue dla sub-taska, tak jak opisano w podrozdziale 13.3.3.1.
// subTaskManager.createSubTaskIssueLink(<obiekt parent Issue>, <obiekt utworzonego sub-tasku typu interfejsowego Issue>);

// 5. Wyświetlenie wyników.
// subTasks: [BP1-4, BP1-5, BP1-6]
return "subTasks: ${subTasks.collect() {subTask -> subTask.getKey()}}";