// LISTING 2.7. Instrukcje warunkowe w Groovym

import com.atlassian.jira.component.ComponentAccessor;

// 1. Zmienne testowe.
int value = 12;
String result = "";

// 2. Blok if... else...
// W przypadku pojedynczych linii podobnie jak w Javie klamry można pomijać.
if (value==12) {
    result = "dwanaście";
} else if (value==1) {
    result = "jeden";
} else {
    result = "ani dwanaście, ani jeden";
}

// 3. Operator Elvis.
// Po warunku stawia się znak ?, a potem dwie opcje dla true lub false rozdzielone znakiem :
// Warunki można zagnieżdżać wielokrotnie, tak jak to przedstawiono w drugim przykładzie.
result = (value>12)?"większe od dwunastu":"mniejsze od dwunastu";
result = (value=12)?"dwanaście":(value=1)?"jeden":"ani dwanaście, ani jeden";

// 4. Operator obiektowy.
// Przed wywołaniem metody na obiekcie umieszcza się znak ?, który wywoła kolejne metody tylko wtedy, jeżeli obiekt nie będzie pusty.
// W poniższym przypadku istnieje ryzyko, że nie ma użytkownika o nazwie anowak, a jeżeli jest, to może nie mieć zdefiniowanego adresu e-mail.
def userEmail = ComponentAccessor.getUserManager().getUserByName("anowak")?.getEmailAddress()?.split("@");

// 5. Wyświetlenie wyników.
// result: dwanaście | userEmail: [jakub0002,gmail.com]
return "result: ${result} | userEmail: ${userEmail}";