// LISTING 2.6. Wykorzystanie klas w skryptach Groovy’ego

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;

// 1. Pobranie menedżerów.
def userPropertyManager = ComponentAccessor.getUserPropertyManager();
def userManager = ComponentAccessor.getUserManager();

// 2. Mapa dostępnych urządzeń.
// Fragment można zastąpić danymi z dowolnego źródła, np.: REST API, plik, wynik zapytania SQL.
Map deviceList = [
    1L:"ST12345",
    2L:"ST12346",
    3L:"ST123457",
    4L:"ST123458",
    5L:"ST123459",
    6L:"ST123460"
];

// 3. Pobranie użytkowników Jiry.
Set allUsers = userManager.getAllUsers();

// 4. Utworzenie listy obiektów typu Device.

// Deklaracja i inicjalizacja pustej listy z obiektami typu nowo zdefiniowanej klasy.
List devices = new ArrayList<Device>();

// Przetworzenie listy użytkowników w pętli each(), zbudowanie obiektów typu Device i dodanie ich do listy devices.
allUsers.each() {
    user ->
        // Pobranie id urządzenia z User property dla aktualnie przetwarzanego użytkownika w pętli each().
        def userDeviceId = userPropertyManager.getPropertySet(user).getString("jira.meta.userDeviceId");

        // Dodanie nowego obiektu Device do listy, jeżeli User property nie było puste.
        if (userDeviceId!=null)
            devices.add(new Device(Long.parseLong(userDeviceId), deviceList.get(Long.parseLong(userDeviceId)), user));
};

// 5. Wyświetlenie wyników. W tym momencie zmienna devices zawiera listę obiektów Device.
// DEVICE | id: 1, serialNumber: ST12345, owner: akowalski
// DEVICE | id: 3, serialNumber: ST12357, owner: mkopernik
// DEVICE | id: 5, serialNumber: ST12359, owner: jnowak
return String.join("<br />", devices.collect(){device -> device.getDeviceAsString()});

// 6. Deklaracja klasy urządzenia.
public class Device {

    // Pola klasy.
    Long id;
    String serialNumber;
    ApplicationUser owner;

    // Konstruktory.
    public Device() {
    }

    public Device(Long id, String serialNumber, ApplicationUser owner) {
        this.id = id;
        this.serialNumber = serialNumber;
        this.owner = owner;
    }

    // Gettery i settery.
    // W omawianym przypadku settery zostały dodane tylko poglądowo i nie będą używane w skrypcie.
    Long getId() {
        return this.id;
    }

    void setId(Long id) {
        this.id = id;
    }

    String getSerialNumber() {
        return this.serialNumber;
    }

    void serSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    String getUserName() {
        return this.owner.getUsername();
    }

    ApplicationUser getUserObject() {
        return this.owner;
    }

    void setUserByUserName(String userName) {
        this.owner = ComponentAccessor.getUserManager().getUserByName(userName);
    }

    String getDeviceAsString() {
        return "DEVICE | id: ${this.getId()}, serialNumber: ${this.serialNumber}, owner: ${this.owner.getUsername()}";
    }
}