// LISTING 26.1. Zmiana wartości atrybutu typu default w ObjectBean

import com.atlassian.jira.component.ComponentAccessor;
import com.onresolve.scriptrunner.runner.customisers.WithPlugin;
@WithPlugin("com.riadalabs.jira.plugins.insight")

// 1. Pobranie komponentu IQLFacade.
Class iqlFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.IQLFacade");
def iqlFacade = ComponentAccessor.getOSGiComponentInstanceOfType(iqlFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.IQLFacade;

// 2. Pobranie komponentu ObjectFacade.
Class objectFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade");
def objectFacade = ComponentAccessor.getOSGiComponentInstanceOfType(objectFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade;

// 3. Pobranie komponentu ObjectTypeAttributeFacade.
Class objectTypeAttributeFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectTypeAttributeFacade");
def objectTypeAttributeFacade = ComponentAccessor.getOSGiComponentInstanceOfType(objectTypeAttributeFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectTypeAttributeFacade;

// 4. Pobranie komponentu ObjectAttributeBeanFactory.
Class objectAttributeBeanFactoryClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.services.model.factory.ObjectAttributeBeanFactory");
def objectAttributeBeanFactory = ComponentAccessor.getOSGiComponentInstanceOfType(objectAttributeBeanFactoryClass) as com.riadalabs.jira.plugins.insight.services.model.factory.ObjectAttributeBeanFactory;

// 5. Wyszukanie i pobranie obiektu Insighta określonego pracownika.
def userObjectToChange = iqlFacade.findObjectsByIQLAndSchema(1, "objectType = Employees and \"Name\" = \"Vincent Wong\"").get(0);

// 6. Modyfikacja atrybutów ObjectBean.

// 6.1. Pobranie atrybutu First name o identyfikatorze 17 z obiektu typu Employee i zrzutowanie na typ modyfikowalny.
def firstNameObjectTypeAttributeBean = objectTypeAttributeFacade.loadObjectTypeAttribute(17).createMutable();

// 6.2. Utworzenie nowego obiektu typu ObjectAttributeBean z nową wartością atrybutu First name.
def newfirstNameObjectAttributeBean = objectAttributeBeanFactory.createObjectAttributeBeanForObject(userObjectToChange, firstNameObjectTypeAttributeBean, "Vincent2");

// 6.3. Zapisanie nowej wartości atrybutu w obiekcie Insight.
objectFacade.storeObjectAttributeBean(newfirstNameObjectAttributeBean);