// LISTING 23.1. Modyfikacja uprawnień do przestrzeni

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import groovy.json.JsonBuilder;

// 1. Inicjalizacja ApplicationLink.
def ApplicationLink getPrimaryConfluenceLink() {
    def applicationLinkService = ComponentLocator.getComponent(ApplicationLinkService);
    final ApplicationLink confluenceApplicationLink = applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType);
    return confluenceApplicationLink;
}

// 2. Inicjalizacja fabryczki do wysyłania żądań przez Confluence API.
def confluenceLink = getPrimaryConfluenceLink();
def authenticatedRequestFactory = confluenceLink.createImpersonatingAuthenticatedRequestFactory();

// 3. Inicjalizacja mapy podstawowych parametrów dla uprawnień do przestrzeni.
def requestBody = [
    "jsonrpc" : "2.0",
    "method" : "addPermissionToSpace",
    "params" : [ "EXPORTSPACE", "username", "pageKey"]
];

// 4. Wykonanie żądania zmiany uprawnień do przestrzeni Confluence.
authenticatedRequestFactory.createRequest(Request.MethodType.POST,"/rpc/json-rpc/confluenceservice-v2?os_authType=basic")
    .addHeader("Content-Type", "application/json")
    .setRequestBody(new JsonBuilder(requestBody).toString())
    .execute(new ResponseHandler<Response>() {

        @Override
        void handle(Response response) throws ResponseException {
            if (response.statusCode != HttpURLConnection.HTTP_OK) {
                throw new Exception(response.getResponseBodyAsString());
            } else {
                log.info "Space permission has been changed.";
            }
        }
    });