// LISTING 22.4. Utworzenie przestrzeni i modyfikacja strony głównej

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import groovy.json.JsonBuilder;
import groovy.json.JsonSlurper;

// 1. Inicjalizacja ApplicationLink.
def ApplicationLink getPrimaryConfluenceLink() {
    def applicationLinkService = ComponentLocator.getComponent(ApplicationLinkService);
    final ApplicationLink confluenceApplicationLink = applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType);
    return confluenceApplicationLink;
}

// 2. Inicjalizacja fabryczki do wysyłania żądań przez Confluence API.
def confluenceLink = getPrimaryConfluenceLink();
def authenticatedRequestFactory = confluenceLink.createImpersonatingAuthenticatedRequestFactory();

// 3. Inicjalizacja mapy podstawowych parametrów dla nowo tworzonej przestrzeni.
def createSpaceRequestBody = [
    key: "SMP2",
    name: "Sample space 2",
    description: [
        plain: [
            value: "Some space description.",
            representation: "plain"
        ]
    ]
];

// 4. Wykonanie operacji utworzenia przestrzeni.
// 4.1. Deklaracja zmiennej dla identyfikatora strony głównej.
def homePageId;
authenticatedRequestFactory
    .createRequest(Request.MethodType.POST, "rest/api/space")
    .addHeader("Content-Type", "application/json")
    .setRequestBody(new JsonBuilder(createSpaceRequestBody).toString())
    .execute(new ResponseHandler<Response>() {

        @Override
        void handle(Response response) throws ResponseException {
            if (response.statusCode != HttpURLConnection.HTTP_OK) {
                throw new Exception(response.getResponseBodyAsString());
            } else {
                log.info "Space has been created.";
        
                // 4.2. Pobranie identyfikatora strony głównej.
                homePageId = new JsonSlurper().parseText(response.responseBodyAsString)["homepage"]["id"];
            }
        }
    });

// 5. Inicjalizacja mapy podstawowych parametrów do aktualizacji strony głównej.
def updateHomePageRequestBody = 
[
    version: [
        number: "2"
    ],
    title: "My new title 1",
    type: "page",
    body: [
        storage: [
            value: "<p>New page data.</p>",
            representation: "storage"
        ]
    ]
];

// 6. Wykonanie aktualizacji strony głównej.
authenticatedRequestFactory
    .createRequest(Request.MethodType.PUT, "/rest/api/content/${homePageId}")
    .addHeader("Content-Type", "application/json")
    .setRequestBody(new JsonBuilder(updateHomePageRequestBody).toString())
    .execute(new ResponseHandler<Response>() {

        @Override
        void handle(Response response) throws ResponseException {
            if (response.statusCode != HttpURLConnection.HTTP_OK) {
                throw new Exception(response.getResponseBodyAsString());
            } else {
                log.info "Page ${homePageId} has been updated.";
            }
        }
    });