// LISTING 22.1. Inicjalizacja ApplicationLink i fabryczki do wysyłania żądań przez Confluence API

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;

// 1. Inicjalizacja ApplicationLink.
def ApplicationLink getPrimaryConfluenceLink() {
    def applicationLinkService = ComponentLocator.getComponent(ApplicationLinkService);
    final ApplicationLink confluenceApplicationLink = applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType);
    return confluenceApplicationLink;
}

// 2. Inicjalizacja fabryczki do wysyłania żądań przez Confluence API.
def confluenceLink = getPrimaryConfluenceLink();
def authenticatedRequestFactory = confluenceLink.createImpersonatingAuthenticatedRequestFactory();