// LISTING 20.5. Zmiana podsumowania zgłoszenia (Summary) za pomocą żądania POST

import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;
import com.onresolve.scriptrunner.runner.rest.common.CustomEndpointDelegate;
import groovy.transform.BaseScript;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
@BaseScript CustomEndpointDelegate delegate

// 1. Metoda POST.
changeSummary(httpMethod: "POST") {
    MultivaluedMap queryParams, String body ->

        // 1.1. Pobranie wartości parametrów przekazanych w żądaniu.
        def issueKey = queryParams.getFirst("issueKey") as String;
        def issueSummary = queryParams.getFirst("summary") as String;

        // 1.2. Pobranie komponentu IssueManager.
        def issueManager = ComponentAccessor.getIssueManager();

        // 1.3. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika z uprawnieniami do wykonywania zmian w zgłoszeniach.
        def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");
        
        // 1.4. Pobranie obiektu typu interfejsowego MutableIssue do modyfikacji.
        def issueToChange = ComponentAccessor.getIssueManager().getIssueObject(issueKey) as MutableIssue;
        
        // 1.5. Zmiana wartości Summary.
        issueToChange.setSummary(issueSummary);
        
        // 1.6. Zapisanie zmiany.
        issueManager.updateIssue(adminUser, issueToChange, EventDispatchOption.ISSUE_UPDATED, false);
        
        // 2. Zwrócenie wyników żądania.
        return Response.ok("ok").build();
}