// LISTING 19.7. Utworzenie zgłoszenia z uzupełnionymi wartościami custom fieldów

// 1. Token użytkownika.
def token = "OTUxODQxMjc3ODIwOs8GGxW31/mPWMI9gH0UqLp+OQRq";

// 2. URI endpointa Jira REST API.
def url = "http://172.16.117.141:8080/rest/api/2/issue/";

// 3. Zainicjowanie ciała zapytania.
// customfield_10115 => text field.
// customfield_10600 => date picker.
// customfield_10601 => select list (multiple choices).
def jsonBody = """
{
    "fields": {
        "project": {"key": "CM"},
        "issuetype": {"name": "Story"},
        "summary": "New issue",
        "description": "Sample description",
        "customfield_10115": "Sample field content",
        "customfield_10600": "2022-07-06",
        "customfield_10601": [{"value": "IT"}, {"value": "HR"}]
    }
}
""";

// 4. Otwarcie połączenia z endpointem.
def connection = url.toURL().openConnection() as HttpURLConnection;

// 5. Dodanie parametrów połączenia.
connection.setRequestMethod("POST");
connection.addRequestProperty("Authorization", "Bearer " + token);
connection.addRequestProperty("X-Atlassian-Token", "no-check");
connection.setDoOutput(true);
connection.addRequestProperty("Content-Type", "application/json");
connection.getOutputStream().write(jsonBody.getBytes("UTF-8"))
connection.setReadTimeout(5000);
connection.connect();

// 6. Odpowiedź po wykonaniu żądania.
if (connection.getResponseCode()==201)
    println("Issue has been created");
else if (connection.getErrorStream()!=null)
    println(connection.getErrorStream().getText());

// 7. Zamknięcie połączenia.
connection.disconnect();