// LISTING 19.5. Zwrócenie listy zarchiwizowanych projektów

import groovy.json.JsonSlurper;

// 1. Token użytkownika.
def token = "OTUxODQxMjc3ODIwOs8GGxW31/mPWMI9gH0UqLp+OQRq";

// 2. URI endpointa Jira REST API.
def url = "http://172.16.117.141:8080/rest/api/2/project?includeArchived=true";

// 3. Otwarcie połączenia z endpointem.
def connection = url.toURL().openConnection() as HttpURLConnection;

// 4. Dodanie parametrów połączenia.
connection.addRequestProperty("Authorization", "Bearer " + token);
connection.addRequestProperty("X-Atlassian-Token", "no-check");
connection.addRequestProperty("Content-Type", "application/json");
connection.setRequestMethod("GET");
connection.setReadTimeout(5000);
connection.connect();

// 5. Załadowanie wyników do obiektu String.
String jsonString = connection.getInputStream().getText("UTF-8");

// 6. Zamknięcie połączenia.
connection.disconnect();

// 7. Zwrócenie wyników.
// W celu wyświetlenia listy w konsoli należy zmienić słowo kluczowe return na println.
return new JsonSlurper().parseText(jsonString).findAll() {
    project -> project["archived"]==true;
}.collect() {
    project -> project["key"];
};